package eu.ipac.ace.ui.exportWizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class IPACExportWizardPage extends WizardPage {

	private Text projectText;
	// private Text uiFileText;
	
	private ISelection selection;

	public IPACExportWizardPage(ISelection selection) {
		super("IPACExportWizardPage");
		setTitle("Create the application bundle");
		setDescription("Select the build file that will generate the deployable application.");
		this.selection = selection;
	}

	@Override
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		container.setLayout(gridLayout);
		setControl(container);

		final Label apTitleLabel = new Label(container, SWT.NONE);
		final GridData apTitleGridData = new GridData();
		apTitleGridData.horizontalSpan = 3;
		apTitleLabel.setLayoutData(apTitleGridData);
		apTitleLabel.setText("Select an ADL project.");

		final Label apLabel = new Label(container, SWT.NONE);
		final GridData apGridData = new GridData(GridData.HORIZONTAL_ALIGN_END);
		apLabel.setLayoutData(apGridData);
		apLabel.setText("ADL Project:");

		projectText = new Text(container, SWT.BORDER);
		projectText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		projectText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		final Button apButton = new Button(container, SWT.NONE);
		apButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				browseForProject();
			}
		});
		apButton.setText("Browse...");
		
		initialize();
		dialogChanged();
		setControl(container);
		
		/*
		final Label label_2 = new Label(container, SWT.NONE);
		final GridData gridData_2 = new GridData();
		gridData_2.horizontalSpan = 3;
		label_2.setLayoutData(gridData_2);

		final Label uiTitleLabel = new Label(container, SWT.NONE);
		final GridData uiTitleGridData = new GridData();
		uiTitleGridData.horizontalSpan = 3;
		uiTitleLabel.setLayoutData(uiTitleGridData);
		uiTitleLabel.setText("Select the User interface JAR file. ");

		final Label uiLlabel = new Label(container, SWT.NONE);
		final GridData uiGridData = new GridData();
		uiGridData.horizontalIndent = 20;
		uiLlabel.setLayoutData(uiGridData);
		uiLlabel.setText("User Interface Template:");

		uiFileText = new Text(container, SWT.BORDER);
		uiFileText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				// updatePageComplete();
			}
		});
		uiFileText.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

		final Button uiButton = new Button(container, SWT.NONE);
		uiButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				 browseForUIFile();
			}
		});
		uiButton.setText("Browse...");
		*/
	}
	
	/**
	 * Tests if the current workbench selection is a suitable container to use.
	 */

	private void initialize() {
		if (selection != null && selection.isEmpty() == false
				&& selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) selection;
			if (ssel.size() > 1)
				return;
			Object obj = ssel.getFirstElement();
			if (obj instanceof IResource) {
				IContainer container;
				if (obj instanceof IContainer)
					container = (IContainer) obj;
				else
					container = ((IResource) obj).getParent();
				
				projectText.setText(container.getFullPath().toString());
			}
		}
	}
	
	/**
	 * Ensures that the projectText field is set an is valid.
	 */
	private void dialogChanged() {
		IResource container = ResourcesPlugin.getWorkspace().getRoot()
				.findMember(new Path(getProjectName()));
		
		if (getProjectName().length() == 0) {
			updateStatus("An ADL project must be specified");
			return;
		}
		
		if (container == null || (container.getType() & (IResource.PROJECT | IResource.FOLDER)) == 0) {
			updateStatus("An ADL project must exist");
			return;
		}
		
		if (!container.isAccessible()) {
			updateStatus("Project must be writable");
			return;
		}
		
		updateStatus(null);
	}
	
	/**
	 * Uses the standard container selection dialog to choose the new value for
	 * the container field.
	 */

	private void browseForProject() {
		ContainerSelectionDialog dialog = new ContainerSelectionDialog(
				getShell(), ResourcesPlugin.getWorkspace().getRoot(), false,
				"Select an ADL project");
		if (dialog.open() == ContainerSelectionDialog.OK) {
			Object[] result = dialog.getResult();
			if (result.length == 1) {
				projectText.setText(((Path) result[0]).toString());
			}
		}
	}
	
	/**
	 * 
	 * @param message
	 */
	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}

	/**
	 * 
	 * @return
	 */
	public String getProjectName() {
		return projectText.getText();
	}
	
	/**
	 * Retrieve the full path of the build file.
	 */
	public IPath getAbsoluteProjectLocation() {
		String text = projectText.getText().trim();
		if (text.length() == 0)
			return null;
		IPath path = new Path(text);
	
		path = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(path);
		/*
		if (!path.isAbsolute())
			path = ResourcesPlugin.getWorkspace().getRoot().getLocation()
					.append(path);
		*/
		
		return path;
	}
	

	/**
	 * Open a file browser dialog to locate a profile file
	 */
	/*
	protected void browseForProfileFile() {
		IPath path = browse(getProfileLocation(), false);
		if (path == null)
			return;
		IPath rootLoc = ResourcesPlugin.getWorkspace().getRoot().getLocation();
		if (rootLoc.isPrefixOf(path))
			path = path.setDevice(null).removeFirstSegments(
					rootLoc.segmentCount());
		buildFileText.setText(path.toString());
	}*/
	
	/**
	 * Open a file dialog for selecting a file
	 * 
	 * @param path
	 *            the initially selected file
	 * @param mustExist
	 *            <code>true</code> if the selected file must already exist,
	 *            else <code>false</code>
	 * @return the newly selected file or <code>null</code>
	 */
	/*
	private IPath browse(IPath path, boolean mustExist) {
		FileDialog dialog = new FileDialog(getShell(), mustExist
				? SWT.OPEN
				: SWT.SAVE);
		if (path != null) {
			if (path.segmentCount() > 1)
				dialog.setFilterPath(path.removeLastSegments(1).toOSString());
			if (path.segmentCount() > 0)
				dialog.setFileName(path.lastSegment());
		}
		String result = dialog.open();
		if (result == null)
			return null;
		return new Path(result);
	}
	*/
}
