package eu.ipac.ace.ui.exportWizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class IPACExportWizard extends Wizard implements IExportWizard {
	
	private IPACExportWizardPage exportPage;
	private IStructuredSelection initialSelection;
	
	public IPACExportWizard() {
		super();
		setNeedsProgressMonitor(true);
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.initialSelection = selection;
	}
	
	public void addPages() {
		setWindowTitle("ACE Export Wizard");
		exportPage = new IPACExportWizardPage(initialSelection);
		addPage(exportPage);
	}
	
	@Override
	public boolean performFinish() {
		 
		final String projectName = exportPage.getProjectName();
		
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException {
				try {
					doFinish(projectName, monitor);
				} catch (CoreException e) {
					throw new InvocationTargetException(e);
				} finally {
					monitor.done();
				}
			}
		};
		
		// System.out.println("BEFORE SECOND TRY");
		try {
			getContainer().run(true, false, op);
		} catch (InterruptedException e) {
			return false;
		} catch (InvocationTargetException e) {
			Throwable realException = e.getTargetException();
			MessageDialog.openError(getShell(), "Error", realException.getMessage());
			return false;
		}
		
		return true;
	}
	
	/**
	 * The worker method. It will find the container, and run the ant script
	 * (i.e build.xml) if it is present.
	 */

	private void doFinish(String projectName, IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("Opening " + projectName, 2);
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IResource resource = root.findMember(new Path(projectName));
		
		System.out.println(projectName);
		
		if (!resource.exists() || !(resource instanceof IContainer)) {
			throwCoreException("Project \"" + projectName + "\" does not exist.");
		}
		monitor.worked(1);
		
		IContainer container = (IContainer) resource;
		// final IFile file = container.getFile(new Path(root.getLocation() + "/build.xml"));
		final File buildFile = new File(root.getLocation() + projectName + "/build.xml");
		
		//final File dir = new File(root.getLocation());
		// System.out.println(file.toString());
		System.out.println(buildFile.toString());
		
		//System.out.println("BEFORE RUNNING");
		if (buildFile.exists()) {
			monitor.setTaskName("Running file...");
			try {
				AntRunner runner = new AntRunner();
				runner.setBuildFileLocation(buildFile.toString());
				runner.setArguments("-Dmessage=Building -verbose");
				runner.run();
			} catch (CoreException e) {
			}
			monitor.worked(1);
			System.out.println("The bundle is created!");
		} else {
			throwCoreException("A \"Build.xml\" does not exist in project \""  + projectName + "\".");
		}
		
		// System.out.println("RUNNING COMPLETED");
	}
	
	private void throwCoreException(String message) throws CoreException {
		IStatus status =
			new Status(IStatus.ERROR, "eu.ipac.ace.ui", IStatus.OK, message, null);
		throw new CoreException(status);
	}
	
	

}
