/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.ipac.ace.gmf.ipacadl.provider;

import eu.ipac.ace.gmf.ipacadl.util.IpacadlAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class IpacadlItemProviderAdapterFactory extends IpacadlAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IpacadlItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.Application} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ApplicationItemProvider applicationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.Application}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createApplicationAdapter() {
		if (applicationItemProvider == null) {
			applicationItemProvider = new ApplicationItemProvider(this);
		}

		return applicationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.EventHandler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventHandlerItemProvider eventHandlerItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.EventHandler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEventHandlerAdapter() {
		if (eventHandlerItemProvider == null) {
			eventHandlerItemProvider = new EventHandlerItemProvider(this);
		}

		return eventHandlerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.EventAssignmentStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventAssignmentStatementItemProvider eventAssignmentStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.EventAssignmentStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEventAssignmentStatementAdapter() {
		if (eventAssignmentStatementItemProvider == null) {
			eventAssignmentStatementItemProvider = new EventAssignmentStatementItemProvider(this);
		}

		return eventAssignmentStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.EntryPoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EntryPointItemProvider entryPointItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.EntryPoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEntryPointAdapter() {
		if (entryPointItemProvider == null) {
			entryPointItemProvider = new EntryPointItemProvider(this);
		}

		return entryPointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.Body} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BodyItemProvider bodyItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.Body}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBodyAdapter() {
		if (bodyItemProvider == null) {
			bodyItemProvider = new BodyItemProvider(this);
		}

		return bodyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.ConstantDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantDeclarationItemProvider constantDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.ConstantDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createConstantDeclarationAdapter() {
		if (constantDeclarationItemProvider == null) {
			constantDeclarationItemProvider = new ConstantDeclarationItemProvider(this);
		}

		return constantDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.VariableDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableDeclarationItemProvider variableDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.VariableDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createVariableDeclarationAdapter() {
		if (variableDeclarationItemProvider == null) {
			variableDeclarationItemProvider = new VariableDeclarationItemProvider(this);
		}

		return variableDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.VectorDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VectorDeclarationItemProvider vectorDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.VectorDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createVectorDeclarationAdapter() {
		if (vectorDeclarationItemProvider == null) {
			vectorDeclarationItemProvider = new VectorDeclarationItemProvider(this);
		}

		return vectorDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.IntegerLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerLiteralItemProvider integerLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.IntegerLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIntegerLiteralAdapter() {
		if (integerLiteralItemProvider == null) {
			integerLiteralItemProvider = new IntegerLiteralItemProvider(this);
		}

		return integerLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.StringLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringLiteralItemProvider stringLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.StringLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStringLiteralAdapter() {
		if (stringLiteralItemProvider == null) {
			stringLiteralItemProvider = new StringLiteralItemProvider(this);
		}

		return stringLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.BooleanLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanLiteralItemProvider booleanLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.BooleanLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBooleanLiteralAdapter() {
		if (booleanLiteralItemProvider == null) {
			booleanLiteralItemProvider = new BooleanLiteralItemProvider(this);
		}

		return booleanLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.DoubleLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleLiteralItemProvider doubleLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.DoubleLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDoubleLiteralAdapter() {
		if (doubleLiteralItemProvider == null) {
			doubleLiteralItemProvider = new DoubleLiteralItemProvider(this);
		}

		return doubleLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.IfStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfStatementItemProvider ifStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.IfStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIfStatementAdapter() {
		if (ifStatementItemProvider == null) {
			ifStatementItemProvider = new IfStatementItemProvider(this);
		}

		return ifStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.SwitchStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SwitchStatementItemProvider switchStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.SwitchStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSwitchStatementAdapter() {
		if (switchStatementItemProvider == null) {
			switchStatementItemProvider = new SwitchStatementItemProvider(this);
		}

		return switchStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.CaseStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CaseStatementItemProvider caseStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.CaseStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCaseStatementAdapter() {
		if (caseStatementItemProvider == null) {
			caseStatementItemProvider = new CaseStatementItemProvider(this);
		}

		return caseStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.DefaultStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultStatementItemProvider defaultStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.DefaultStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDefaultStatementAdapter() {
		if (defaultStatementItemProvider == null) {
			defaultStatementItemProvider = new DefaultStatementItemProvider(this);
		}

		return defaultStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.ListenStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListenStatementItemProvider listenStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.ListenStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createListenStatementAdapter() {
		if (listenStatementItemProvider == null) {
			listenStatementItemProvider = new ListenStatementItemProvider(this);
		}

		return listenStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.InvokeStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvokeStatementItemProvider invokeStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.InvokeStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createInvokeStatementAdapter() {
		if (invokeStatementItemProvider == null) {
			invokeStatementItemProvider = new InvokeStatementItemProvider(this);
		}

		return invokeStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.PrimitiveElementList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveElementListItemProvider primitiveElementListItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.PrimitiveElementList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPrimitiveElementListAdapter() {
		if (primitiveElementListItemProvider == null) {
			primitiveElementListItemProvider = new PrimitiveElementListItemProvider(this);
		}

		return primitiveElementListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.FaultStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FaultStatementItemProvider faultStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.FaultStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFaultStatementAdapter() {
		if (faultStatementItemProvider == null) {
			faultStatementItemProvider = new FaultStatementItemProvider(this);
		}

		return faultStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.AssignmentStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssignmentStatementItemProvider assignmentStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.AssignmentStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createAssignmentStatementAdapter() {
		if (assignmentStatementItemProvider == null) {
			assignmentStatementItemProvider = new AssignmentStatementItemProvider(this);
		}

		return assignmentStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.IterationStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IterationStatementItemProvider iterationStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.IterationStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIterationStatementAdapter() {
		if (iterationStatementItemProvider == null) {
			iterationStatementItemProvider = new IterationStatementItemProvider(this);
		}

		return iterationStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.BreakStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BreakStatementItemProvider breakStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.BreakStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBreakStatementAdapter() {
		if (breakStatementItemProvider == null) {
			breakStatementItemProvider = new BreakStatementItemProvider(this);
		}

		return breakStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.WaitStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WaitStatementItemProvider waitStatementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.WaitStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createWaitStatementAdapter() {
		if (waitStatementItemProvider == null) {
			waitStatementItemProvider = new WaitStatementItemProvider(this);
		}

		return waitStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.PrimitiveElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveElementItemProvider primitiveElementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.PrimitiveElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPrimitiveElementAdapter() {
		if (primitiveElementItemProvider == null) {
			primitiveElementItemProvider = new PrimitiveElementItemProvider(this);
		}

		return primitiveElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.Expression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionItemProvider expressionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.Expression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createExpressionAdapter() {
		if (expressionItemProvider == null) {
			expressionItemProvider = new ExpressionItemProvider(this);
		}

		return expressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.ConditionalAndExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalAndExpressionItemProvider conditionalAndExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.ConditionalAndExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createConditionalAndExpressionAdapter() {
		if (conditionalAndExpressionItemProvider == null) {
			conditionalAndExpressionItemProvider = new ConditionalAndExpressionItemProvider(this);
		}

		return conditionalAndExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.EqualityExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EqualityExpressionItemProvider equalityExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.EqualityExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEqualityExpressionAdapter() {
		if (equalityExpressionItemProvider == null) {
			equalityExpressionItemProvider = new EqualityExpressionItemProvider(this);
		}

		return equalityExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.RelationalExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationalExpressionItemProvider relationalExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.RelationalExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRelationalExpressionAdapter() {
		if (relationalExpressionItemProvider == null) {
			relationalExpressionItemProvider = new RelationalExpressionItemProvider(this);
		}

		return relationalExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.AdditiveExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdditiveExpressionItemProvider additiveExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.AdditiveExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createAdditiveExpressionAdapter() {
		if (additiveExpressionItemProvider == null) {
			additiveExpressionItemProvider = new AdditiveExpressionItemProvider(this);
		}

		return additiveExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.ipac.ace.gmf.ipacadl.MultiplicativeExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiplicativeExpressionItemProvider multiplicativeExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.ipac.ace.gmf.ipacadl.MultiplicativeExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createMultiplicativeExpressionAdapter() {
		if (multiplicativeExpressionItemProvider == null) {
			multiplicativeExpressionItemProvider = new MultiplicativeExpressionItemProvider(this);
		}

		return multiplicativeExpressionItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (applicationItemProvider != null) applicationItemProvider.dispose();
		if (eventHandlerItemProvider != null) eventHandlerItemProvider.dispose();
		if (eventAssignmentStatementItemProvider != null) eventAssignmentStatementItemProvider.dispose();
		if (entryPointItemProvider != null) entryPointItemProvider.dispose();
		if (bodyItemProvider != null) bodyItemProvider.dispose();
		if (constantDeclarationItemProvider != null) constantDeclarationItemProvider.dispose();
		if (variableDeclarationItemProvider != null) variableDeclarationItemProvider.dispose();
		if (vectorDeclarationItemProvider != null) vectorDeclarationItemProvider.dispose();
		if (integerLiteralItemProvider != null) integerLiteralItemProvider.dispose();
		if (stringLiteralItemProvider != null) stringLiteralItemProvider.dispose();
		if (booleanLiteralItemProvider != null) booleanLiteralItemProvider.dispose();
		if (doubleLiteralItemProvider != null) doubleLiteralItemProvider.dispose();
		if (ifStatementItemProvider != null) ifStatementItemProvider.dispose();
		if (switchStatementItemProvider != null) switchStatementItemProvider.dispose();
		if (caseStatementItemProvider != null) caseStatementItemProvider.dispose();
		if (defaultStatementItemProvider != null) defaultStatementItemProvider.dispose();
		if (listenStatementItemProvider != null) listenStatementItemProvider.dispose();
		if (invokeStatementItemProvider != null) invokeStatementItemProvider.dispose();
		if (primitiveElementListItemProvider != null) primitiveElementListItemProvider.dispose();
		if (faultStatementItemProvider != null) faultStatementItemProvider.dispose();
		if (assignmentStatementItemProvider != null) assignmentStatementItemProvider.dispose();
		if (iterationStatementItemProvider != null) iterationStatementItemProvider.dispose();
		if (breakStatementItemProvider != null) breakStatementItemProvider.dispose();
		if (waitStatementItemProvider != null) waitStatementItemProvider.dispose();
		if (primitiveElementItemProvider != null) primitiveElementItemProvider.dispose();
		if (expressionItemProvider != null) expressionItemProvider.dispose();
		if (conditionalAndExpressionItemProvider != null) conditionalAndExpressionItemProvider.dispose();
		if (equalityExpressionItemProvider != null) equalityExpressionItemProvider.dispose();
		if (relationalExpressionItemProvider != null) relationalExpressionItemProvider.dispose();
		if (additiveExpressionItemProvider != null) additiveExpressionItemProvider.dispose();
		if (multiplicativeExpressionItemProvider != null) multiplicativeExpressionItemProvider.dispose();
	}

}
