package eu.ipac.ace.gmf.ipacadl.diagram.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;

import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.*;
import eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry;
import eu.ipac.ace.gmf.ipacadl.diagram.view.factories.*;

/**
 * @generated
 */
public class IpacadlViewProvider extends AbstractViewProvider {

	/**
	 * @generated
	 */
	protected Class getDiagramViewClass(IAdaptable semanticAdapter,
			String diagramKind) {
		EObject semanticElement = getSemanticElement(semanticAdapter);
		if (ApplicationEditPart.MODEL_ID.equals(diagramKind)
				&& IpacadlVisualIDRegistry.getDiagramVisualID(semanticElement) != -1) {
			return ApplicationViewFactory.class;
		}
		return null;
	}

	/**
	 * @generated
	 */
	protected Class getNodeViewClass(IAdaptable semanticAdapter,
			View containerView, String semanticHint) {
		if (containerView == null) {
			return null;
		}
		IElementType elementType = getSemanticElementType(semanticAdapter);
		EObject domainElement = getSemanticElement(semanticAdapter);
		int visualID;
		if (semanticHint == null) {
			// Semantic hint is not specified. Can be a result of call from CanonicalEditPolicy.
			// In this situation there should be NO elementType, visualID will be determined
			// by VisualIDRegistry.getNodeVisualID() for domainElement.
			if (elementType != null || domainElement == null) {
				return null;
			}
			visualID = IpacadlVisualIDRegistry.getNodeVisualID(containerView,
					domainElement);
		} else {
			visualID = IpacadlVisualIDRegistry.getVisualID(semanticHint);
			if (elementType != null) {
				// Semantic hint is specified together with element type.
				// Both parameters should describe exactly the same diagram element.
				// In addition we check that visualID returned by VisualIDRegistry.getNodeVisualID() for
				// domainElement (if specified) is the same as in element type.
				if (!IpacadlElementTypes.isKnownElementType(elementType)
						|| (!(elementType instanceof IHintedType))) {
					return null; // foreign element type
				}
				String elementTypeHint = ((IHintedType) elementType)
						.getSemanticHint();
				if (!semanticHint.equals(elementTypeHint)) {
					return null; // if semantic hint is specified it should be the same as in element type
				}
				if (domainElement != null
						&& visualID != IpacadlVisualIDRegistry.getNodeVisualID(
								containerView, domainElement)) {
					return null; // visual id for node EClass should match visual id from element type
				}
			} else {
				// Element type is not specified. Domain element should be present (except pure design elements).
				// This method is called with EObjectAdapter as parameter from:
				//   - ViewService.createNode(View container, EObject eObject, String type, PreferencesHint preferencesHint) 
				//   - generated ViewFactory.decorateView() for parent element
				if (!ApplicationEditPart.MODEL_ID
						.equals(IpacadlVisualIDRegistry
								.getModelID(containerView))) {
					return null; // foreign diagram
				}
				switch (visualID) {
				case BodyEditPart.VISUAL_ID:
				case VectorDeclarationEditPart.VISUAL_ID:
				case VariableDeclarationEditPart.VISUAL_ID:
				case ConstantDeclarationEditPart.VISUAL_ID:
				case EventHandlerEditPart.VISUAL_ID:
				case WaitStatementEditPart.VISUAL_ID:
				case BreakStatementEditPart.VISUAL_ID:
				case InvokeStatementEditPart.VISUAL_ID:
				case FaultStatementEditPart.VISUAL_ID:
				case IterationStatementEditPart.VISUAL_ID:
				case ExpressionEditPart.VISUAL_ID:
				case IfStatementEditPart.VISUAL_ID:
				case AssignmentStatementEditPart.VISUAL_ID:
				case BooleanLiteralEditPart.VISUAL_ID:
				case DoubleLiteralEditPart.VISUAL_ID:
				case IntegerLiteralEditPart.VISUAL_ID:
				case StringLiteralEditPart.VISUAL_ID:
				case EventAssignmentStatementEditPart.VISUAL_ID:
				case WaitStatement2EditPart.VISUAL_ID:
				case BreakStatement2EditPart.VISUAL_ID:
				case InvokeStatement2EditPart.VISUAL_ID:
				case WaitStatement3EditPart.VISUAL_ID:
				case BreakStatement3EditPart.VISUAL_ID:
				case InvokeStatement3EditPart.VISUAL_ID:
				case IterationStatement2EditPart.VISUAL_ID:
				case Expression2EditPart.VISUAL_ID:
				case WaitStatement4EditPart.VISUAL_ID:
				case BreakStatement4EditPart.VISUAL_ID:
				case InvokeStatement4EditPart.VISUAL_ID:
				case IterationStatement3EditPart.VISUAL_ID:
				case Expression3EditPart.VISUAL_ID:
				case InvokeStatement5EditPart.VISUAL_ID:
				case IfStatement2EditPart.VISUAL_ID:
				case AssignmentStatement2EditPart.VISUAL_ID:
				case WaitStatement5EditPart.VISUAL_ID:
				case BreakStatement5EditPart.VISUAL_ID:
				case InvokeStatement6EditPart.VISUAL_ID:
				case IterationStatement4EditPart.VISUAL_ID:
				case IfStatement3EditPart.VISUAL_ID:
				case AssignmentStatement3EditPart.VISUAL_ID:
				case IfStatement4EditPart.VISUAL_ID:
				case AssignmentStatement4EditPart.VISUAL_ID:
				case IterationStatement5EditPart.VISUAL_ID:
				case IfStatement5EditPart.VISUAL_ID:
				case AssignmentStatement5EditPart.VISUAL_ID:
				case BooleanLiteral2EditPart.VISUAL_ID:
				case DoubleLiteral2EditPart.VISUAL_ID:
				case IntegerLiteral2EditPart.VISUAL_ID:
				case StringLiteral2EditPart.VISUAL_ID:
				case WaitStatement6EditPart.VISUAL_ID:
				case BreakStatement6EditPart.VISUAL_ID:
				case InvokeStatement7EditPart.VISUAL_ID:
				case IterationStatement6EditPart.VISUAL_ID:
				case IfStatement6EditPart.VISUAL_ID:
				case AssignmentStatement6EditPart.VISUAL_ID:
					if (domainElement == null
							|| visualID != IpacadlVisualIDRegistry
									.getNodeVisualID(containerView,
											domainElement)) {
						return null; // visual id in semantic hint should match visual id for domain element
					}
					break;
				case BodyCompartmentStatementEditPart.VISUAL_ID:
					if (BodyEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case VectorDeclarationNameEditPart.VISUAL_ID:
					if (VectorDeclarationEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case VariableDeclarationNameEditPart.VISUAL_ID:
					if (VariableDeclarationEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case ConstantDeclarationNameEditPart.VISUAL_ID:
					if (ConstantDeclarationEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case EventHandlerNameEditPart.VISUAL_ID:
				case EventHandlerCompartmentEventHandlerStatementsPropertiesEditPart.VISUAL_ID:
					if (EventHandlerEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case WaitStatementSecsEditPart.VISUAL_ID:
					if (WaitStatementEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case InvokeStatementComponentNameEditPart.VISUAL_ID:
				case InvokeStatementMethodNameEditPart.VISUAL_ID:
					if (InvokeStatementEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case FaultStatementCompartmentOnFaultStatementsEditPart.VISUAL_ID:
					if (FaultStatementEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case WaitStatementSecs2EditPart.VISUAL_ID:
					if (WaitStatement2EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case InvokeStatementComponentName2EditPart.VISUAL_ID:
				case InvokeStatementMethodName2EditPart.VISUAL_ID:
					if (InvokeStatement2EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IterationStatementCompartmentWhileExpressionEditPart.VISUAL_ID:
				case IterationStatementCompartmentWhileStatementEditPart.VISUAL_ID:
					if (IterationStatementEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case ExpressionStrExpressionEditPart.VISUAL_ID:
					if (ExpressionEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case WaitStatementSecs3EditPart.VISUAL_ID:
					if (WaitStatement3EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case InvokeStatementComponentName3EditPart.VISUAL_ID:
				case InvokeStatementMethodName3EditPart.VISUAL_ID:
					if (InvokeStatement3EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IterationStatementCompartmentWhileExpression2EditPart.VISUAL_ID:
				case IterationStatementCompartmentWhileStatement2EditPart.VISUAL_ID:
					if (IterationStatement2EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IfStatementCompartmentIfExpressionEditPart.VISUAL_ID:
				case IfStatementCompartmentIfStatementEditPart.VISUAL_ID:
				case IfStatementCompartmentElseStatementEditPart.VISUAL_ID:
					if (IfStatementEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case ExpressionStrExpression2EditPart.VISUAL_ID:
					if (Expression2EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case WaitStatementSecs4EditPart.VISUAL_ID:
					if (WaitStatement4EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case InvokeStatementComponentName4EditPart.VISUAL_ID:
				case InvokeStatementMethodName4EditPart.VISUAL_ID:
					if (InvokeStatement4EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IterationStatementCompartmentWhileExpression3EditPart.VISUAL_ID:
				case IterationStatementCompartmentWhileStatement3EditPart.VISUAL_ID:
					if (IterationStatement3EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case ExpressionStrExpression3EditPart.VISUAL_ID:
					if (Expression3EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case InvokeStatementComponentName5EditPart.VISUAL_ID:
				case InvokeStatementMethodName5EditPart.VISUAL_ID:
					if (InvokeStatement5EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IfStatementCompartmentIfExpression2EditPart.VISUAL_ID:
				case IfStatementCompartmentIfStatement2EditPart.VISUAL_ID:
				case IfStatementCompartmentElseStatement2EditPart.VISUAL_ID:
					if (IfStatement2EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case WaitStatementSecs5EditPart.VISUAL_ID:
					if (WaitStatement5EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case InvokeStatementComponentName6EditPart.VISUAL_ID:
				case InvokeStatementMethodName6EditPart.VISUAL_ID:
					if (InvokeStatement6EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IterationStatementCompartmentWhileExpression4EditPart.VISUAL_ID:
				case IterationStatementCompartmentWhileStatement4EditPart.VISUAL_ID:
					if (IterationStatement4EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IfStatementCompartmentIfExpression3EditPart.VISUAL_ID:
				case IfStatementCompartmentIfStatement3EditPart.VISUAL_ID:
				case IfStatementCompartmentElseStatement3EditPart.VISUAL_ID:
					if (IfStatement3EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IfStatementCompartmentIfExpression4EditPart.VISUAL_ID:
				case IfStatementCompartmentIfStatement4EditPart.VISUAL_ID:
				case IfStatementCompartmentElseStatement4EditPart.VISUAL_ID:
					if (IfStatement4EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IterationStatementCompartmentWhileExpression5EditPart.VISUAL_ID:
				case IterationStatementCompartmentWhileStatement5EditPart.VISUAL_ID:
					if (IterationStatement5EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IfStatementCompartmentIfExpression5EditPart.VISUAL_ID:
				case IfStatementCompartmentIfStatement5EditPart.VISUAL_ID:
				case IfStatementCompartmentElseStatement5EditPart.VISUAL_ID:
					if (IfStatement5EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case EventAssignmentStatementPropIdEditPart.VISUAL_ID:
					if (EventAssignmentStatementEditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case WaitStatementSecs6EditPart.VISUAL_ID:
					if (WaitStatement6EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case InvokeStatementComponentName7EditPart.VISUAL_ID:
				case InvokeStatementMethodName7EditPart.VISUAL_ID:
					if (InvokeStatement7EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IterationStatementCompartmentWhileExpression6EditPart.VISUAL_ID:
				case IterationStatementCompartmentWhileStatement6EditPart.VISUAL_ID:
					if (IterationStatement6EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				case IfStatementCompartmentIfExpression6EditPart.VISUAL_ID:
				case IfStatementCompartmentIfStatement6EditPart.VISUAL_ID:
				case IfStatementCompartmentElseStatement6EditPart.VISUAL_ID:
					if (IfStatement6EditPart.VISUAL_ID != IpacadlVisualIDRegistry
							.getVisualID(containerView)
							|| containerView.getElement() != domainElement) {
						return null; // wrong container
					}
					break;
				default:
					return null;
				}
			}
		}
		return getNodeViewClass(containerView, visualID);
	}

	/**
	 * @generated
	 */
	protected Class getNodeViewClass(View containerView, int visualID) {
		if (containerView == null
				|| !IpacadlVisualIDRegistry.canCreateNode(containerView,
						visualID)) {
			return null;
		}
		switch (visualID) {
		case BodyEditPart.VISUAL_ID:
			return BodyViewFactory.class;
		case VectorDeclarationEditPart.VISUAL_ID:
			return VectorDeclarationViewFactory.class;
		case VectorDeclarationNameEditPart.VISUAL_ID:
			return VectorDeclarationNameViewFactory.class;
		case VariableDeclarationEditPart.VISUAL_ID:
			return VariableDeclarationViewFactory.class;
		case VariableDeclarationNameEditPart.VISUAL_ID:
			return VariableDeclarationNameViewFactory.class;
		case ConstantDeclarationEditPart.VISUAL_ID:
			return ConstantDeclarationViewFactory.class;
		case ConstantDeclarationNameEditPart.VISUAL_ID:
			return ConstantDeclarationNameViewFactory.class;
		case EventHandlerEditPart.VISUAL_ID:
			return EventHandlerViewFactory.class;
		case EventHandlerNameEditPart.VISUAL_ID:
			return EventHandlerNameViewFactory.class;
		case WaitStatementEditPart.VISUAL_ID:
			return WaitStatementViewFactory.class;
		case WaitStatementSecsEditPart.VISUAL_ID:
			return WaitStatementSecsViewFactory.class;
		case BreakStatementEditPart.VISUAL_ID:
			return BreakStatementViewFactory.class;
		case InvokeStatementEditPart.VISUAL_ID:
			return InvokeStatementViewFactory.class;
		case InvokeStatementComponentNameEditPart.VISUAL_ID:
			return InvokeStatementComponentNameViewFactory.class;
		case InvokeStatementMethodNameEditPart.VISUAL_ID:
			return InvokeStatementMethodNameViewFactory.class;
		case FaultStatementEditPart.VISUAL_ID:
			return FaultStatementViewFactory.class;
		case WaitStatement2EditPart.VISUAL_ID:
			return WaitStatement2ViewFactory.class;
		case WaitStatementSecs2EditPart.VISUAL_ID:
			return WaitStatementSecs2ViewFactory.class;
		case BreakStatement2EditPart.VISUAL_ID:
			return BreakStatement2ViewFactory.class;
		case InvokeStatement2EditPart.VISUAL_ID:
			return InvokeStatement2ViewFactory.class;
		case InvokeStatementComponentName2EditPart.VISUAL_ID:
			return InvokeStatementComponentName2ViewFactory.class;
		case InvokeStatementMethodName2EditPart.VISUAL_ID:
			return InvokeStatementMethodName2ViewFactory.class;
		case IterationStatementEditPart.VISUAL_ID:
			return IterationStatementViewFactory.class;
		case ExpressionEditPart.VISUAL_ID:
			return ExpressionViewFactory.class;
		case ExpressionStrExpressionEditPart.VISUAL_ID:
			return ExpressionStrExpressionViewFactory.class;
		case WaitStatement3EditPart.VISUAL_ID:
			return WaitStatement3ViewFactory.class;
		case WaitStatementSecs3EditPart.VISUAL_ID:
			return WaitStatementSecs3ViewFactory.class;
		case BreakStatement3EditPart.VISUAL_ID:
			return BreakStatement3ViewFactory.class;
		case InvokeStatement3EditPart.VISUAL_ID:
			return InvokeStatement3ViewFactory.class;
		case InvokeStatementComponentName3EditPart.VISUAL_ID:
			return InvokeStatementComponentName3ViewFactory.class;
		case InvokeStatementMethodName3EditPart.VISUAL_ID:
			return InvokeStatementMethodName3ViewFactory.class;
		case IterationStatement2EditPart.VISUAL_ID:
			return IterationStatement2ViewFactory.class;
		case IfStatementEditPart.VISUAL_ID:
			return IfStatementViewFactory.class;
		case Expression2EditPart.VISUAL_ID:
			return Expression2ViewFactory.class;
		case ExpressionStrExpression2EditPart.VISUAL_ID:
			return ExpressionStrExpression2ViewFactory.class;
		case WaitStatement4EditPart.VISUAL_ID:
			return WaitStatement4ViewFactory.class;
		case WaitStatementSecs4EditPart.VISUAL_ID:
			return WaitStatementSecs4ViewFactory.class;
		case BreakStatement4EditPart.VISUAL_ID:
			return BreakStatement4ViewFactory.class;
		case InvokeStatement4EditPart.VISUAL_ID:
			return InvokeStatement4ViewFactory.class;
		case InvokeStatementComponentName4EditPart.VISUAL_ID:
			return InvokeStatementComponentName4ViewFactory.class;
		case InvokeStatementMethodName4EditPart.VISUAL_ID:
			return InvokeStatementMethodName4ViewFactory.class;
		case IterationStatement3EditPart.VISUAL_ID:
			return IterationStatement3ViewFactory.class;
		case AssignmentStatementEditPart.VISUAL_ID:
			return AssignmentStatementViewFactory.class;
		case Expression3EditPart.VISUAL_ID:
			return Expression3ViewFactory.class;
		case ExpressionStrExpression3EditPart.VISUAL_ID:
			return ExpressionStrExpression3ViewFactory.class;
		case InvokeStatement5EditPart.VISUAL_ID:
			return InvokeStatement5ViewFactory.class;
		case InvokeStatementComponentName5EditPart.VISUAL_ID:
			return InvokeStatementComponentName5ViewFactory.class;
		case InvokeStatementMethodName5EditPart.VISUAL_ID:
			return InvokeStatementMethodName5ViewFactory.class;
		case IfStatement2EditPart.VISUAL_ID:
			return IfStatement2ViewFactory.class;
		case AssignmentStatement2EditPart.VISUAL_ID:
			return AssignmentStatement2ViewFactory.class;
		case WaitStatement5EditPart.VISUAL_ID:
			return WaitStatement5ViewFactory.class;
		case WaitStatementSecs5EditPart.VISUAL_ID:
			return WaitStatementSecs5ViewFactory.class;
		case BreakStatement5EditPart.VISUAL_ID:
			return BreakStatement5ViewFactory.class;
		case InvokeStatement6EditPart.VISUAL_ID:
			return InvokeStatement6ViewFactory.class;
		case InvokeStatementComponentName6EditPart.VISUAL_ID:
			return InvokeStatementComponentName6ViewFactory.class;
		case InvokeStatementMethodName6EditPart.VISUAL_ID:
			return InvokeStatementMethodName6ViewFactory.class;
		case IterationStatement4EditPart.VISUAL_ID:
			return IterationStatement4ViewFactory.class;
		case IfStatement3EditPart.VISUAL_ID:
			return IfStatement3ViewFactory.class;
		case AssignmentStatement3EditPart.VISUAL_ID:
			return AssignmentStatement3ViewFactory.class;
		case IfStatement4EditPart.VISUAL_ID:
			return IfStatement4ViewFactory.class;
		case AssignmentStatement4EditPart.VISUAL_ID:
			return AssignmentStatement4ViewFactory.class;
		case IterationStatement5EditPart.VISUAL_ID:
			return IterationStatement5ViewFactory.class;
		case IfStatement5EditPart.VISUAL_ID:
			return IfStatement5ViewFactory.class;
		case AssignmentStatement5EditPart.VISUAL_ID:
			return AssignmentStatement5ViewFactory.class;
		case BooleanLiteralEditPart.VISUAL_ID:
			return BooleanLiteralViewFactory.class;
		case DoubleLiteralEditPart.VISUAL_ID:
			return DoubleLiteralViewFactory.class;
		case IntegerLiteralEditPart.VISUAL_ID:
			return IntegerLiteralViewFactory.class;
		case StringLiteralEditPart.VISUAL_ID:
			return StringLiteralViewFactory.class;
		case BooleanLiteral2EditPart.VISUAL_ID:
			return BooleanLiteral2ViewFactory.class;
		case DoubleLiteral2EditPart.VISUAL_ID:
			return DoubleLiteral2ViewFactory.class;
		case IntegerLiteral2EditPart.VISUAL_ID:
			return IntegerLiteral2ViewFactory.class;
		case StringLiteral2EditPart.VISUAL_ID:
			return StringLiteral2ViewFactory.class;
		case EventAssignmentStatementEditPart.VISUAL_ID:
			return EventAssignmentStatementViewFactory.class;
		case EventAssignmentStatementPropIdEditPart.VISUAL_ID:
			return EventAssignmentStatementPropIdViewFactory.class;
		case WaitStatement6EditPart.VISUAL_ID:
			return WaitStatement6ViewFactory.class;
		case WaitStatementSecs6EditPart.VISUAL_ID:
			return WaitStatementSecs6ViewFactory.class;
		case BreakStatement6EditPart.VISUAL_ID:
			return BreakStatement6ViewFactory.class;
		case InvokeStatement7EditPart.VISUAL_ID:
			return InvokeStatement7ViewFactory.class;
		case InvokeStatementComponentName7EditPart.VISUAL_ID:
			return InvokeStatementComponentName7ViewFactory.class;
		case InvokeStatementMethodName7EditPart.VISUAL_ID:
			return InvokeStatementMethodName7ViewFactory.class;
		case IterationStatement6EditPart.VISUAL_ID:
			return IterationStatement6ViewFactory.class;
		case IfStatement6EditPart.VISUAL_ID:
			return IfStatement6ViewFactory.class;
		case AssignmentStatement6EditPart.VISUAL_ID:
			return AssignmentStatement6ViewFactory.class;
		case BodyCompartmentStatementEditPart.VISUAL_ID:
			return BodyCompartmentStatementViewFactory.class;
		case FaultStatementCompartmentOnFaultStatementsEditPart.VISUAL_ID:
			return FaultStatementCompartmentOnFaultStatementsViewFactory.class;
		case IterationStatementCompartmentWhileExpressionEditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileExpressionViewFactory.class;
		case IterationStatementCompartmentWhileStatementEditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileStatementViewFactory.class;
		case IterationStatementCompartmentWhileExpression2EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileExpression2ViewFactory.class;
		case IterationStatementCompartmentWhileStatement2EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileStatement2ViewFactory.class;
		case IfStatementCompartmentIfExpressionEditPart.VISUAL_ID:
			return IfStatementCompartmentIfExpressionViewFactory.class;
		case IfStatementCompartmentIfStatementEditPart.VISUAL_ID:
			return IfStatementCompartmentIfStatementViewFactory.class;
		case IfStatementCompartmentElseStatementEditPart.VISUAL_ID:
			return IfStatementCompartmentElseStatementViewFactory.class;
		case IterationStatementCompartmentWhileExpression3EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileExpression3ViewFactory.class;
		case IterationStatementCompartmentWhileStatement3EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileStatement3ViewFactory.class;
		case IfStatementCompartmentIfExpression2EditPart.VISUAL_ID:
			return IfStatementCompartmentIfExpression2ViewFactory.class;
		case IfStatementCompartmentIfStatement2EditPart.VISUAL_ID:
			return IfStatementCompartmentIfStatement2ViewFactory.class;
		case IfStatementCompartmentElseStatement2EditPart.VISUAL_ID:
			return IfStatementCompartmentElseStatement2ViewFactory.class;
		case IterationStatementCompartmentWhileExpression4EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileExpression4ViewFactory.class;
		case IterationStatementCompartmentWhileStatement4EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileStatement4ViewFactory.class;
		case IfStatementCompartmentIfExpression3EditPart.VISUAL_ID:
			return IfStatementCompartmentIfExpression3ViewFactory.class;
		case IfStatementCompartmentIfStatement3EditPart.VISUAL_ID:
			return IfStatementCompartmentIfStatement3ViewFactory.class;
		case IfStatementCompartmentElseStatement3EditPart.VISUAL_ID:
			return IfStatementCompartmentElseStatement3ViewFactory.class;
		case IfStatementCompartmentIfExpression4EditPart.VISUAL_ID:
			return IfStatementCompartmentIfExpression4ViewFactory.class;
		case IfStatementCompartmentIfStatement4EditPart.VISUAL_ID:
			return IfStatementCompartmentIfStatement4ViewFactory.class;
		case IfStatementCompartmentElseStatement4EditPart.VISUAL_ID:
			return IfStatementCompartmentElseStatement4ViewFactory.class;
		case IterationStatementCompartmentWhileExpression5EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileExpression5ViewFactory.class;
		case IterationStatementCompartmentWhileStatement5EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileStatement5ViewFactory.class;
		case IfStatementCompartmentIfExpression5EditPart.VISUAL_ID:
			return IfStatementCompartmentIfExpression5ViewFactory.class;
		case IfStatementCompartmentIfStatement5EditPart.VISUAL_ID:
			return IfStatementCompartmentIfStatement5ViewFactory.class;
		case IfStatementCompartmentElseStatement5EditPart.VISUAL_ID:
			return IfStatementCompartmentElseStatement5ViewFactory.class;
		case EventHandlerCompartmentEventHandlerStatementsPropertiesEditPart.VISUAL_ID:
			return EventHandlerCompartmentEventHandlerStatementsPropertiesViewFactory.class;
		case IterationStatementCompartmentWhileExpression6EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileExpression6ViewFactory.class;
		case IterationStatementCompartmentWhileStatement6EditPart.VISUAL_ID:
			return IterationStatementCompartmentWhileStatement6ViewFactory.class;
		case IfStatementCompartmentIfExpression6EditPart.VISUAL_ID:
			return IfStatementCompartmentIfExpression6ViewFactory.class;
		case IfStatementCompartmentIfStatement6EditPart.VISUAL_ID:
			return IfStatementCompartmentIfStatement6ViewFactory.class;
		case IfStatementCompartmentElseStatement6EditPart.VISUAL_ID:
			return IfStatementCompartmentElseStatement6ViewFactory.class;
		}
		return null;
	}

	/**
	 * @generated
	 */
	protected Class getEdgeViewClass(IAdaptable semanticAdapter,
			View containerView, String semanticHint) {
		IElementType elementType = getSemanticElementType(semanticAdapter);
		if (!IpacadlElementTypes.isKnownElementType(elementType)
				|| (!(elementType instanceof IHintedType))) {
			return null; // foreign element type
		}
		String elementTypeHint = ((IHintedType) elementType).getSemanticHint();
		if (elementTypeHint == null) {
			return null; // our hint is visual id and must be specified
		}
		if (semanticHint != null && !semanticHint.equals(elementTypeHint)) {
			return null; // if semantic hint is specified it should be the same as in element type
		}
		int visualID = IpacadlVisualIDRegistry.getVisualID(elementTypeHint);
		EObject domainElement = getSemanticElement(semanticAdapter);
		if (domainElement != null
				&& visualID != IpacadlVisualIDRegistry
						.getLinkWithClassVisualID(domainElement)) {
			return null; // visual id for link EClass should match visual id from element type
		}
		return getEdgeViewClass(visualID);
	}

	/**
	 * @generated
	 */
	protected Class getEdgeViewClass(int visualID) {
		switch (visualID) {
		case StatementConnectionEditPart.VISUAL_ID:
			return StatementConnectionViewFactory.class;
		}
		return null;
	}

	/**
	 * @generated
	 */
	private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
		if (semanticAdapter == null) {
			return null;
		}
		return (IElementType) semanticAdapter.getAdapter(IElementType.class);
	}
}
