package eu.ipac.ace.gmf.ipacadl.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

import eu.ipac.ace.gmf.ipacadl.Application;
import eu.ipac.ace.gmf.ipacadl.IpacadlPackage;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.*;

/**
 * This registry is used to determine which type of visual object should be
 * created for the corresponding Diagram, Node, ChildNode or Link represented
 * by a domain model object.
 * 
 * @generated
 */
public class IpacadlVisualIDRegistry {

	/**
	 * @generated
	 */
	private static final String DEBUG_KEY = "eu.ipac.ace.gmf.diagram/debug/visualID"; //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static int getVisualID(View view) {
		if (view instanceof Diagram) {
			if (ApplicationEditPart.MODEL_ID.equals(view.getType())) {
				return ApplicationEditPart.VISUAL_ID;
			} else {
				return -1;
			}
		}
		return eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry
				.getVisualID(view.getType());
	}

	/**
	 * @generated
	 */
	public static String getModelID(View view) {
		View diagram = view.getDiagram();
		while (view != diagram) {
			EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
			if (annotation != null) {
				return (String) annotation.getDetails().get("modelID"); //$NON-NLS-1$
			}
			view = (View) view.eContainer();
		}
		return diagram != null ? diagram.getType() : null;
	}

	/**
	 * @generated
	 */
	public static int getVisualID(String type) {
		try {
			return Integer.parseInt(type);
		} catch (NumberFormatException e) {
			if (Boolean.TRUE.toString().equalsIgnoreCase(
					Platform.getDebugOption(DEBUG_KEY))) {
				IpacadlDiagramEditorPlugin.getInstance().logError(
						"Unable to parse view type as a visualID number: "
								+ type);
			}
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static String getType(int visualID) {
		return String.valueOf(visualID);
	}

	/**
	 * @generated
	 */
	public static int getDiagramVisualID(EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		if (IpacadlPackage.eINSTANCE.getApplication().isSuperTypeOf(
				domainElement.eClass())
				&& isDiagram((Application) domainElement)) {
			return ApplicationEditPart.VISUAL_ID;
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static int getNodeVisualID(View containerView, EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		String containerModelID = eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry
				.getModelID(containerView);
		if (!ApplicationEditPart.MODEL_ID.equals(containerModelID)) {
			return -1;
		}
		int containerVisualID;
		if (ApplicationEditPart.MODEL_ID.equals(containerModelID)) {
			containerVisualID = eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry
					.getVisualID(containerView);
		} else {
			if (containerView instanceof Diagram) {
				containerVisualID = ApplicationEditPart.VISUAL_ID;
			} else {
				return -1;
			}
		}
		switch (containerVisualID) {
		case VariableDeclarationEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getBooleanLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return BooleanLiteralEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getDoubleLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return DoubleLiteralEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIntegerLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return IntegerLiteralEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getStringLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return StringLiteralEditPart.VISUAL_ID;
			}
			break;
		case ConstantDeclarationEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getBooleanLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return BooleanLiteral2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getDoubleLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return DoubleLiteral2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIntegerLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return IntegerLiteral2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getStringLiteral().isSuperTypeOf(
					domainElement.eClass())) {
				return StringLiteral2EditPart.VISUAL_ID;
			}
			break;
		case InvokeStatementEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getFaultStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return FaultStatementEditPart.VISUAL_ID;
			}
			break;
		case InvokeStatement2EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getFaultStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return FaultStatementEditPart.VISUAL_ID;
			}
			break;
		case InvokeStatement3EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getFaultStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return FaultStatementEditPart.VISUAL_ID;
			}
			break;
		case InvokeStatement4EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getFaultStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return FaultStatementEditPart.VISUAL_ID;
			}
			break;
		case AssignmentStatementEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement5EditPart.VISUAL_ID;
			}
			break;
		case InvokeStatement5EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getFaultStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return FaultStatementEditPart.VISUAL_ID;
			}
			break;
		case AssignmentStatement2EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement5EditPart.VISUAL_ID;
			}
			break;
		case InvokeStatement6EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getFaultStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return FaultStatementEditPart.VISUAL_ID;
			}
			break;
		case AssignmentStatement3EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement5EditPart.VISUAL_ID;
			}
			break;
		case AssignmentStatement4EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement5EditPart.VISUAL_ID;
			}
			break;
		case AssignmentStatement5EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement5EditPart.VISUAL_ID;
			}
			break;
		case InvokeStatement7EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getFaultStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return FaultStatementEditPart.VISUAL_ID;
			}
			break;
		case AssignmentStatement6EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement5EditPart.VISUAL_ID;
			}
			break;
		case BodyCompartmentStatementEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement5EditPart.VISUAL_ID;
			}
			break;
		case FaultStatementCompartmentOnFaultStatementsEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement4EditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileExpressionEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return ExpressionEditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileStatementEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatementEditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileExpression2EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return ExpressionEditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileStatement2EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatementEditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfExpressionEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfStatementEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentElseStatementEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement3EditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileExpression3EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return ExpressionEditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileStatement3EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatementEditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfExpression2EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfStatement2EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentElseStatement2EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement3EditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileExpression4EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return ExpressionEditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileStatement4EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatementEditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfExpression3EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfStatement3EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentElseStatement3EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement3EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfExpression4EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfStatement4EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentElseStatement4EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement3EditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileExpression5EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return ExpressionEditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileStatement5EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatementEditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfExpression5EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfStatement5EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentElseStatement5EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement3EditPart.VISUAL_ID;
			}
			break;
		case EventHandlerCompartmentEventHandlerStatementsPropertiesEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getEventAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return EventAssignmentStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement7EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement6EditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileExpression6EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return ExpressionEditPart.VISUAL_ID;
			}
			break;
		case IterationStatementCompartmentWhileStatement6EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatementEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatementEditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfExpression6EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getExpression().isSuperTypeOf(
					domainElement.eClass())) {
				return Expression2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentIfStatement6EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement2EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement2EditPart.VISUAL_ID;
			}
			break;
		case IfStatementCompartmentElseStatement6EditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getWaitStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return WaitStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getBreakStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return BreakStatement5EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getInvokeStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return InvokeStatement6EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIterationStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IterationStatement4EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getIfStatement().isSuperTypeOf(
					domainElement.eClass())) {
				return IfStatement3EditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getAssignmentStatement()
					.isSuperTypeOf(domainElement.eClass())) {
				return AssignmentStatement3EditPart.VISUAL_ID;
			}
			break;
		case ApplicationEditPart.VISUAL_ID:
			if (IpacadlPackage.eINSTANCE.getBody().isSuperTypeOf(
					domainElement.eClass())) {
				return BodyEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getVectorDeclaration().isSuperTypeOf(
					domainElement.eClass())) {
				return VectorDeclarationEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getVariableDeclaration()
					.isSuperTypeOf(domainElement.eClass())) {
				return VariableDeclarationEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getConstantDeclaration()
					.isSuperTypeOf(domainElement.eClass())) {
				return ConstantDeclarationEditPart.VISUAL_ID;
			}
			if (IpacadlPackage.eINSTANCE.getEventHandler().isSuperTypeOf(
					domainElement.eClass())) {
				return EventHandlerEditPart.VISUAL_ID;
			}
			break;
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static boolean canCreateNode(View containerView, int nodeVisualID) {
		String containerModelID = eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry
				.getModelID(containerView);
		if (!ApplicationEditPart.MODEL_ID.equals(containerModelID)) {
			return false;
		}
		int containerVisualID;
		if (ApplicationEditPart.MODEL_ID.equals(containerModelID)) {
			containerVisualID = eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry
					.getVisualID(containerView);
		} else {
			if (containerView instanceof Diagram) {
				containerVisualID = ApplicationEditPart.VISUAL_ID;
			} else {
				return false;
			}
		}
		switch (containerVisualID) {
		case BodyEditPart.VISUAL_ID:
			if (BodyCompartmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case VectorDeclarationEditPart.VISUAL_ID:
			if (VectorDeclarationNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case VariableDeclarationEditPart.VISUAL_ID:
			if (VariableDeclarationNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BooleanLiteralEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (DoubleLiteralEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IntegerLiteralEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (StringLiteralEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case ConstantDeclarationEditPart.VISUAL_ID:
			if (ConstantDeclarationNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BooleanLiteral2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (DoubleLiteral2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IntegerLiteral2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (StringLiteral2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case EventHandlerEditPart.VISUAL_ID:
			if (EventHandlerNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (EventHandlerCompartmentEventHandlerStatementsPropertiesEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case WaitStatementEditPart.VISUAL_ID:
			if (WaitStatementSecsEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case InvokeStatementEditPart.VISUAL_ID:
			if (InvokeStatementComponentNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementMethodNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (FaultStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case FaultStatementEditPart.VISUAL_ID:
			if (FaultStatementCompartmentOnFaultStatementsEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case WaitStatement2EditPart.VISUAL_ID:
			if (WaitStatementSecs2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case InvokeStatement2EditPart.VISUAL_ID:
			if (InvokeStatementComponentName2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementMethodName2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (FaultStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementEditPart.VISUAL_ID:
			if (IterationStatementCompartmentWhileExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatementCompartmentWhileStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case ExpressionEditPart.VISUAL_ID:
			if (ExpressionStrExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case WaitStatement3EditPart.VISUAL_ID:
			if (WaitStatementSecs3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case InvokeStatement3EditPart.VISUAL_ID:
			if (InvokeStatementComponentName3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementMethodName3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (FaultStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatement2EditPart.VISUAL_ID:
			if (IterationStatementCompartmentWhileExpression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatementCompartmentWhileStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementEditPart.VISUAL_ID:
			if (IfStatementCompartmentIfExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentIfStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentElseStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case Expression2EditPart.VISUAL_ID:
			if (ExpressionStrExpression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case WaitStatement4EditPart.VISUAL_ID:
			if (WaitStatementSecs4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case InvokeStatement4EditPart.VISUAL_ID:
			if (InvokeStatementComponentName4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementMethodName4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (FaultStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatement3EditPart.VISUAL_ID:
			if (IterationStatementCompartmentWhileExpression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatementCompartmentWhileStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case AssignmentStatementEditPart.VISUAL_ID:
			if (Expression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case Expression3EditPart.VISUAL_ID:
			if (ExpressionStrExpression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case InvokeStatement5EditPart.VISUAL_ID:
			if (InvokeStatementComponentName5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementMethodName5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (FaultStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatement2EditPart.VISUAL_ID:
			if (IfStatementCompartmentIfExpression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentIfStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentElseStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case AssignmentStatement2EditPart.VISUAL_ID:
			if (Expression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case WaitStatement5EditPart.VISUAL_ID:
			if (WaitStatementSecs5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case InvokeStatement6EditPart.VISUAL_ID:
			if (InvokeStatementComponentName6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementMethodName6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (FaultStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatement4EditPart.VISUAL_ID:
			if (IterationStatementCompartmentWhileExpression4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatementCompartmentWhileStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatement3EditPart.VISUAL_ID:
			if (IfStatementCompartmentIfExpression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentIfStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentElseStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case AssignmentStatement3EditPart.VISUAL_ID:
			if (Expression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatement4EditPart.VISUAL_ID:
			if (IfStatementCompartmentIfExpression4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentIfStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentElseStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case AssignmentStatement4EditPart.VISUAL_ID:
			if (Expression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatement5EditPart.VISUAL_ID:
			if (IterationStatementCompartmentWhileExpression5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatementCompartmentWhileStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatement5EditPart.VISUAL_ID:
			if (IfStatementCompartmentIfExpression5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentIfStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentElseStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case AssignmentStatement5EditPart.VISUAL_ID:
			if (Expression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case EventAssignmentStatementEditPart.VISUAL_ID:
			if (EventAssignmentStatementPropIdEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case WaitStatement6EditPart.VISUAL_ID:
			if (WaitStatementSecs6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case InvokeStatement7EditPart.VISUAL_ID:
			if (InvokeStatementComponentName7EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementMethodName7EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (FaultStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatement6EditPart.VISUAL_ID:
			if (IterationStatementCompartmentWhileExpression6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatementCompartmentWhileStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatement6EditPart.VISUAL_ID:
			if (IfStatementCompartmentIfExpression6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentIfStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementCompartmentElseStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case AssignmentStatement6EditPart.VISUAL_ID:
			if (Expression3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case BodyCompartmentStatementEditPart.VISUAL_ID:
			if (WaitStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case FaultStatementCompartmentOnFaultStatementsEditPart.VISUAL_ID:
			if (WaitStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileExpressionEditPart.VISUAL_ID:
			if (ExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileStatementEditPart.VISUAL_ID:
			if (WaitStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileExpression2EditPart.VISUAL_ID:
			if (ExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileStatement2EditPart.VISUAL_ID:
			if (WaitStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfExpressionEditPart.VISUAL_ID:
			if (Expression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfStatementEditPart.VISUAL_ID:
			if (WaitStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentElseStatementEditPart.VISUAL_ID:
			if (WaitStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileExpression3EditPart.VISUAL_ID:
			if (ExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileStatement3EditPart.VISUAL_ID:
			if (WaitStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfExpression2EditPart.VISUAL_ID:
			if (Expression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfStatement2EditPart.VISUAL_ID:
			if (WaitStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentElseStatement2EditPart.VISUAL_ID:
			if (WaitStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileExpression4EditPart.VISUAL_ID:
			if (ExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileStatement4EditPart.VISUAL_ID:
			if (WaitStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfExpression3EditPart.VISUAL_ID:
			if (Expression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfStatement3EditPart.VISUAL_ID:
			if (WaitStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentElseStatement3EditPart.VISUAL_ID:
			if (WaitStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfExpression4EditPart.VISUAL_ID:
			if (Expression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfStatement4EditPart.VISUAL_ID:
			if (WaitStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentElseStatement4EditPart.VISUAL_ID:
			if (WaitStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileExpression5EditPart.VISUAL_ID:
			if (ExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileStatement5EditPart.VISUAL_ID:
			if (WaitStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfExpression5EditPart.VISUAL_ID:
			if (Expression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfStatement5EditPart.VISUAL_ID:
			if (WaitStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentElseStatement5EditPart.VISUAL_ID:
			if (WaitStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case EventHandlerCompartmentEventHandlerStatementsPropertiesEditPart.VISUAL_ID:
			if (EventAssignmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (WaitStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement7EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileExpression6EditPart.VISUAL_ID:
			if (ExpressionEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IterationStatementCompartmentWhileStatement6EditPart.VISUAL_ID:
			if (WaitStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatementEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfExpression6EditPart.VISUAL_ID:
			if (Expression2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentIfStatement6EditPart.VISUAL_ID:
			if (WaitStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement2EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IfStatementCompartmentElseStatement6EditPart.VISUAL_ID:
			if (WaitStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (BreakStatement5EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (InvokeStatement6EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IterationStatement4EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (IfStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (AssignmentStatement3EditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case ApplicationEditPart.VISUAL_ID:
			if (BodyEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (VectorDeclarationEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (VariableDeclarationEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (ConstantDeclarationEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (EventHandlerEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		}
		return false;
	}

	/**
	 * @generated
	 */
	public static int getLinkWithClassVisualID(EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 * 
	 * @generated
	 */
	private static boolean isDiagram(Application element) {
		return true;
	}

}
