package eu.ipac.ace.gmf.ipacadl.diagram.part;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;

import eu.ipac.ace.gmf.ipacadl.diagram.providers.IpacadlElementTypes;

/**
 * @generated
 */
public class IpacadlPaletteFactory {

	/**
	 * @generated NOT
	 */
	public static String descriptionOfEachCreationTool = "Invoke";
	/**
	 * @generated NOT
	 */
	public static PaletteRoot editorsPalette;
	
	/**
	 * @generated NOT
	 */
	public void fillPalette(PaletteRoot paletteRoot) {
		editorsPalette = paletteRoot;
		paletteRoot.add(createWorkflowPatterns1Group());
		paletteRoot.add(createServicesGroup());
	}

	/**
	 * @generated NOT
	 */
	private PaletteContainer createServicesGroup() {
		PaletteDrawer paletteContainer = new PaletteDrawer(
				"Services");
		ArrayList<Object> AllServices = eu.ipac.ace.adl.Utilities.getServices();
		for (int i=0; i<AllServices.size(); i++){
			paletteContainer.add(createCurrentServiceInvokeCreationTool((String) AllServices.get(i)));
		}
		return paletteContainer;
	}	

	/**
	 * @generated NOT
	 */
	private PaletteStack createCurrentServiceInvokeCreationTool(String nameOfService){
		PaletteStack currentPaletteStack =
			new PaletteStack(
					nameOfService, 
					"current Service Description" , 
					eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlDiagramEditorPlugin.
							findImageDescriptor("/ipacdsl_gmf/icons/Invoke.JPG")
					);
		ArrayList<Object> AllMethods = eu.ipac.ace.adl.Utilities.getServiceMethods(nameOfService);
		currentPaletteStack.add(dummyEntryForServices(nameOfService));
		for (int i=0; i<AllMethods.size(); i++){
			String oneMethod = (String) AllMethods.get(i);
			oneMethod = oneMethod.substring(0, oneMethod.indexOf("(") - 1);
			currentPaletteStack.add(createServiceInvokeCreationTool(nameOfService, oneMethod));
		}
		return currentPaletteStack;
	}

	/**
	 * @generated NOT
	 */
	private ToolEntry dummyEntryForServices(String nameOfService){
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		NodeToolEntry entry = new NodeToolEntry(
			nameOfService,
			nameOfService,
			types);
		entry.setSmallIcon(null);
		entry.setLargeIcon(entry.getSmallIcon());
		entry.setLabel(nameOfService);
		return entry;
		}
	
	/**
	 * @generated NOT
	 */
	private ToolEntry createServiceInvokeCreationTool(String nameOfService, String nameOfMethod) {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(7);
		types.add(IpacadlElementTypes.InvokeStatement_2003);
		types.add(IpacadlElementTypes.InvokeStatement_2007);
		types.add(IpacadlElementTypes.InvokeStatement_2012);
		types.add(IpacadlElementTypes.InvokeStatement_2018);
		types.add(IpacadlElementTypes.InvokeStatement_2022);
		types.add(IpacadlElementTypes.InvokeStatement_2027);
		types.add(IpacadlElementTypes.InvokeStatement_2047);
		NodeToolEntry entry = new NodeToolEntry(
				"Service: " + nameOfService + ", " + "Method: " + nameOfMethod,
				"Service: " + nameOfService + ", " + "Method: " + nameOfMethod, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Invoke.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		
		int numberOfParametersOfMethod = eu.ipac.ace.adl.Utilities.getMethodParamNum(nameOfService, nameOfMethod);
		String returnTypeOfMethod = eu.ipac.ace.adl.Utilities.getMethodReturnedType(nameOfService, nameOfMethod);
		int indexOf_ = returnTypeOfMethod.indexOf("_");
		if((indexOf_ > 0) && (indexOf_ < returnTypeOfMethod.length())){
			returnTypeOfMethod = returnTypeOfMethod.substring(0, indexOf_);
		}
		else if (returnTypeOfMethod == null){
			returnTypeOfMethod = "void";
		}
		String theParameters = "";
		for(int i=0; i<numberOfParametersOfMethod; i++){
			String eachParameterType = eu.ipac.ace.adl.Utilities.getParameterTypeByPosition(nameOfService, nameOfMethod, Integer.toString(i+1));
			int indexOf_inEachParameterType = eachParameterType.indexOf("_");
			if((indexOf_inEachParameterType > 0) && (indexOf_inEachParameterType < eachParameterType.length())){
				eachParameterType = eachParameterType.substring(0, indexOf_inEachParameterType);
			}
			else if (eachParameterType == null){
				eachParameterType = "void";
			}
			theParameters = theParameters + eachParameterType;
			if (i!=numberOfParametersOfMethod-1){
				theParameters = theParameters + ", ";
			}
			//System.out.println(ipac.acc.adl.Utilities.getParameters(nameOfService, nameOfMethod));
		}
		entry.setLabel(returnTypeOfMethod + " " + nameOfMethod + "(" + theParameters + ")");
		
		return entry;
	}

	
	/**
	 * Creates "Workflow Patterns" palette tool group
	 * @generated
	 */
	private PaletteContainer createWorkflowPatterns1Group() {
		PaletteDrawer paletteContainer = new PaletteDrawer(
				Messages.WorkflowPatterns1Group_title);
		paletteContainer.add(new PaletteSeparator());
		paletteContainer.add(createConnection2CreationTool());
		paletteContainer.add(new PaletteSeparator());
		paletteContainer.add(createBody4CreationTool());
		paletteContainer.add(createEventHandler5CreationTool());
		paletteContainer.add(createEventAssignStatement6CreationTool());
		paletteContainer.add(new PaletteSeparator());
		paletteContainer.add(createConstant8CreationTool());
		paletteContainer.add(createVariable9CreationTool());
		paletteContainer.add(createVector10CreationTool());
		paletteContainer.add(new PaletteSeparator());
		paletteContainer.add(createInteger12CreationTool());
		paletteContainer.add(createBoolean13CreationTool());
		paletteContainer.add(createDouble14CreationTool());
		paletteContainer.add(createString15CreationTool());
		paletteContainer.add(new PaletteSeparator());
		paletteContainer.add(createExpression17CreationTool());
		paletteContainer.add(new PaletteSeparator());
		paletteContainer.add(createIf19CreationTool());
		paletteContainer.add(createWhile20CreationTool());
		paletteContainer.add(createWait21CreationTool());
		paletteContainer.add(createBreak22CreationTool());
		paletteContainer.add(createInvoke23CreationTool());
		paletteContainer.add(createOnFault24CreationTool());
		paletteContainer.add(createAssign25CreationTool());
		return paletteContainer;
	}

	/**
	 * @generated
	 */
	private ToolEntry createConnection2CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.StatementConnection_3001);
		LinkToolEntry entry = new LinkToolEntry(
				Messages.Connection2CreationTool_title,
				Messages.Connection2CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Arrow.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createBody4CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.Body_1001);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Body4CreationTool_title,
				Messages.Body4CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Body.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createEventHandler5CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.EventHandler_1005);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.EventHandler5CreationTool_title,
				Messages.EventHandler5CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/EventHandler.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createEventAssignStatement6CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.EventAssignmentStatement_2044);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.EventAssignStatement6CreationTool_title,
				Messages.EventAssignStatement6CreationTool_desc, types);
		entry
				.setSmallIcon(IpacadlDiagramEditorPlugin
						.findImageDescriptor("/ipacdsl_gmf/icons/EventAssignStatement.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createConstant8CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.ConstantDeclaration_1004);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Constant8CreationTool_title,
				Messages.Constant8CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Constant.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createVariable9CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.VariableDeclaration_1003);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Variable9CreationTool_title,
				Messages.Variable9CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Variable.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createVector10CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.VectorDeclaration_1002);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Vector10CreationTool_title,
				Messages.Vector10CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Vector.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createInteger12CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(IpacadlElementTypes.IntegerLiteral_2038);
		types.add(IpacadlElementTypes.IntegerLiteral_2042);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Integer12CreationTool_title,
				Messages.Integer12CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Integer.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createBoolean13CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(IpacadlElementTypes.BooleanLiteral_2036);
		types.add(IpacadlElementTypes.BooleanLiteral_2040);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Boolean13CreationTool_title,
				Messages.Boolean13CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Boolean.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createDouble14CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(IpacadlElementTypes.DoubleLiteral_2037);
		types.add(IpacadlElementTypes.DoubleLiteral_2041);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Double14CreationTool_title,
				Messages.Double14CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Double.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createString15CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(IpacadlElementTypes.StringLiteral_2039);
		types.add(IpacadlElementTypes.StringLiteral_2043);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.String15CreationTool_title,
				Messages.String15CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/String.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createExpression17CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(3);
		types.add(IpacadlElementTypes.Expression_2009);
		types.add(IpacadlElementTypes.Expression_2015);
		types.add(IpacadlElementTypes.Expression_2021);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Expression17CreationTool_title,
				Messages.Expression17CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/IfExpression.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createIf19CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(6);
		types.add(IpacadlElementTypes.IfStatement_2014);
		types.add(IpacadlElementTypes.IfStatement_2023);
		types.add(IpacadlElementTypes.IfStatement_2029);
		types.add(IpacadlElementTypes.IfStatement_2031);
		types.add(IpacadlElementTypes.IfStatement_2034);
		types.add(IpacadlElementTypes.IfStatement_2049);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.If19CreationTool_title,
				Messages.If19CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/If.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createWhile20CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(6);
		types.add(IpacadlElementTypes.IterationStatement_2008);
		types.add(IpacadlElementTypes.IterationStatement_2013);
		types.add(IpacadlElementTypes.IterationStatement_2019);
		types.add(IpacadlElementTypes.IterationStatement_2028);
		types.add(IpacadlElementTypes.IterationStatement_2033);
		types.add(IpacadlElementTypes.IterationStatement_2048);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.While20CreationTool_title,
				Messages.While20CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/While.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createWait21CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(6);
		types.add(IpacadlElementTypes.WaitStatement_2001);
		types.add(IpacadlElementTypes.WaitStatement_2005);
		types.add(IpacadlElementTypes.WaitStatement_2010);
		types.add(IpacadlElementTypes.WaitStatement_2016);
		types.add(IpacadlElementTypes.WaitStatement_2025);
		types.add(IpacadlElementTypes.WaitStatement_2045);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Wait21CreationTool_title,
				Messages.Wait21CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Wait.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createBreak22CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(6);
		types.add(IpacadlElementTypes.BreakStatement_2002);
		types.add(IpacadlElementTypes.BreakStatement_2006);
		types.add(IpacadlElementTypes.BreakStatement_2011);
		types.add(IpacadlElementTypes.BreakStatement_2017);
		types.add(IpacadlElementTypes.BreakStatement_2026);
		types.add(IpacadlElementTypes.BreakStatement_2046);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Break22CreationTool_title,
				Messages.Break22CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Break.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createInvoke23CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(7);
		types.add(IpacadlElementTypes.InvokeStatement_2003);
		types.add(IpacadlElementTypes.InvokeStatement_2007);
		types.add(IpacadlElementTypes.InvokeStatement_2012);
		types.add(IpacadlElementTypes.InvokeStatement_2018);
		types.add(IpacadlElementTypes.InvokeStatement_2022);
		types.add(IpacadlElementTypes.InvokeStatement_2027);
		types.add(IpacadlElementTypes.InvokeStatement_2047);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Invoke23CreationTool_title,
				Messages.Invoke23CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Invoke.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createOnFault24CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(IpacadlElementTypes.FaultStatement_2004);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.OnFault24CreationTool_title,
				Messages.OnFault24CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/OnFault.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createAssign25CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(6);
		types.add(IpacadlElementTypes.AssignmentStatement_2020);
		types.add(IpacadlElementTypes.AssignmentStatement_2024);
		types.add(IpacadlElementTypes.AssignmentStatement_2030);
		types.add(IpacadlElementTypes.AssignmentStatement_2032);
		types.add(IpacadlElementTypes.AssignmentStatement_2035);
		types.add(IpacadlElementTypes.AssignmentStatement_2050);
		NodeToolEntry entry = new NodeToolEntry(
				Messages.Assign25CreationTool_title,
				Messages.Assign25CreationTool_desc, types);
		entry.setSmallIcon(IpacadlDiagramEditorPlugin
				.findImageDescriptor("/ipacdsl_gmf/icons/Assign.JPG")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private static class NodeToolEntry extends ToolEntry {

		/**
		 * @generated
		 */
		private final List elementTypes;

		/**
		 * @generated
		 */
		private NodeToolEntry(String title, String description,
				List elementTypes) {
			super(title, description, null, null);
			this.elementTypes = elementTypes;
		}

		/**
		 * @generated NOT
		 */
		public Tool createTool() {
			descriptionOfEachCreationTool = this.getDescription();
			Tool tool = new UnspecifiedTypeCreationTool(elementTypes);
			tool.setProperties(getToolProperties());
			return tool;
		}
	}

	/**
	 * @generated
	 */
	private static class LinkToolEntry extends ToolEntry {

		/**
		 * @generated
		 */
		private final List relationshipTypes;

		/**
		 * @generated
		 */
		private LinkToolEntry(String title, String description,
				List relationshipTypes) {
			super(title, description, null, null);
			this.relationshipTypes = relationshipTypes;
		}

		/**
		 * @generated
		 */
		public Tool createTool() {
			Tool tool = new UnspecifiedTypeConnectionTool(relationshipTypes);
			tool.setProperties(getToolProperties());
			return tool;
		}
	}
}
