package eu.ipac.ace.gmf.ipacadl.diagram.edit.policies;

import java.util.Iterator;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

import eu.ipac.ace.gmf.ipacadl.IpacadlPackage;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.BooleanLiteralCreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.DoubleLiteralCreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.IntegerLiteralCreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.StringLiteralCreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.BooleanLiteralEditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.DoubleLiteralEditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.IntegerLiteralEditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.StringLiteralEditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry;
import eu.ipac.ace.gmf.ipacadl.diagram.providers.IpacadlElementTypes;

/**
 * @generated
 */
public class VariableDeclarationItemSemanticEditPolicy extends
		IpacadlBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	protected Command getCreateCommand(CreateElementRequest req) {
		if (IpacadlElementTypes.BooleanLiteral_2036 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getVariableDeclaration_CValue());
			}
			return getGEFWrapper(new BooleanLiteralCreateCommand(req));
		}
		if (IpacadlElementTypes.DoubleLiteral_2037 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getVariableDeclaration_CValue());
			}
			return getGEFWrapper(new DoubleLiteralCreateCommand(req));
		}
		if (IpacadlElementTypes.IntegerLiteral_2038 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getVariableDeclaration_CValue());
			}
			return getGEFWrapper(new IntegerLiteralCreateCommand(req));
		}
		if (IpacadlElementTypes.StringLiteral_2039 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getVariableDeclaration_CValue());
			}
			return getGEFWrapper(new StringLiteralCreateCommand(req));
		}
		return super.getCreateCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getDestroyElementCommand(DestroyElementRequest req) {
		CompoundCommand cc = getDestroyEdgesCommand();
		addDestroyChildNodesCommand(cc);
		addDestroyShortcutsCommand(cc);
		View view = (View) getHost().getModel();
		if (view.getEAnnotation("Shortcut") != null) { //$NON-NLS-1$
			req.setElementToDestroy(view);
		}
		cc.add(getGEFWrapper(new DestroyElementCommand(req)));
		return cc.unwrap();
	}

	/**
	 * @generated
	 */
	protected void addDestroyChildNodesCommand(CompoundCommand cmd) {
		View view = (View) getHost().getModel();
		EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
		if (annotation != null) {
			return;
		}
		for (Iterator it = view.getChildren().iterator(); it.hasNext();) {
			Node node = (Node) it.next();
			switch (IpacadlVisualIDRegistry.getVisualID(node)) {
			case BooleanLiteralEditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			case DoubleLiteralEditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			case IntegerLiteralEditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			case StringLiteralEditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			}
		}
	}

}
