package eu.ipac.ace.gmf.ipacadl.diagram.edit.policies;

import java.util.Iterator;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

import eu.ipac.ace.gmf.ipacadl.IpacadlPackage;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.FaultStatementCreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.StatementConnectionCreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.StatementConnectionReorientCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.FaultStatementEditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.StatementConnectionEditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry;
import eu.ipac.ace.gmf.ipacadl.diagram.providers.IpacadlElementTypes;

/**
 * @generated
 */
public class InvokeStatement2ItemSemanticEditPolicy extends
		IpacadlBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	protected Command getCreateCommand(CreateElementRequest req) {
		if (IpacadlElementTypes.FaultStatement_2004 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getInvokeStatement_FaultStatement());
			}
			return getGEFWrapper(new FaultStatementCreateCommand(req));
		}
		return super.getCreateCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getDestroyElementCommand(DestroyElementRequest req) {
		CompoundCommand cc = getDestroyEdgesCommand();
		addDestroyChildNodesCommand(cc);
		addDestroyShortcutsCommand(cc);
		cc.add(getGEFWrapper(new DestroyElementCommand(req)));
		return cc.unwrap();
	}

	/**
	 * @generated
	 */
	protected void addDestroyChildNodesCommand(CompoundCommand cmd) {
		View view = (View) getHost().getModel();
		EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
		if (annotation != null) {
			return;
		}
		for (Iterator it = view.getChildren().iterator(); it.hasNext();) {
			Node node = (Node) it.next();
			switch (IpacadlVisualIDRegistry.getVisualID(node)) {
			case FaultStatementEditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			}
		}
	}

	/**
	 * @generated
	 */
	protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
		Command command = req.getTarget() == null ? getStartCreateRelationshipCommand(req)
				: getCompleteCreateRelationshipCommand(req);
		return command != null ? command : super
				.getCreateRelationshipCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getStartCreateRelationshipCommand(
			CreateRelationshipRequest req) {
		if (IpacadlElementTypes.StatementConnection_3001 == req
				.getElementType()) {
			return getGEFWrapper(new StatementConnectionCreateCommand(req, req
					.getSource(), req.getTarget()));
		}
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getCompleteCreateRelationshipCommand(
			CreateRelationshipRequest req) {
		if (IpacadlElementTypes.StatementConnection_3001 == req
				.getElementType()) {
			return getGEFWrapper(new StatementConnectionCreateCommand(req, req
					.getSource(), req.getTarget()));
		}
		return null;
	}

	/**
	 * Returns command to reorient EReference based link. New link target or source
	 * should be the domain model element associated with this node.
	 * 
	 * @generated
	 */
	protected Command getReorientReferenceRelationshipCommand(
			ReorientReferenceRelationshipRequest req) {
		switch (getVisualID(req)) {
		case StatementConnectionEditPart.VISUAL_ID:
			return getGEFWrapper(new StatementConnectionReorientCommand(req));
		}
		return super.getReorientReferenceRelationshipCommand(req);
	}

}
