package eu.ipac.ace.gmf.ipacadl.diagram.edit.policies;

import java.util.Iterator;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

import eu.ipac.ace.gmf.ipacadl.IpacadlPackage;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.BooleanLiteral2CreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.DoubleLiteral2CreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.IntegerLiteral2CreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.commands.StringLiteral2CreateCommand;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.BooleanLiteral2EditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.DoubleLiteral2EditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.IntegerLiteral2EditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.parts.StringLiteral2EditPart;
import eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry;
import eu.ipac.ace.gmf.ipacadl.diagram.providers.IpacadlElementTypes;

/**
 * @generated
 */
public class ConstantDeclarationItemSemanticEditPolicy extends
		IpacadlBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	protected Command getCreateCommand(CreateElementRequest req) {
		if (IpacadlElementTypes.BooleanLiteral_2040 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getConstantDeclaration_CValue());
			}
			return getGEFWrapper(new BooleanLiteral2CreateCommand(req));
		}
		if (IpacadlElementTypes.DoubleLiteral_2041 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getConstantDeclaration_CValue());
			}
			return getGEFWrapper(new DoubleLiteral2CreateCommand(req));
		}
		if (IpacadlElementTypes.IntegerLiteral_2042 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getConstantDeclaration_CValue());
			}
			return getGEFWrapper(new IntegerLiteral2CreateCommand(req));
		}
		if (IpacadlElementTypes.StringLiteral_2043 == req.getElementType()) {
			if (req.getContainmentFeature() == null) {
				req.setContainmentFeature(IpacadlPackage.eINSTANCE
						.getConstantDeclaration_CValue());
			}
			return getGEFWrapper(new StringLiteral2CreateCommand(req));
		}
		return super.getCreateCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getDestroyElementCommand(DestroyElementRequest req) {
		CompoundCommand cc = getDestroyEdgesCommand();
		addDestroyChildNodesCommand(cc);
		addDestroyShortcutsCommand(cc);
		View view = (View) getHost().getModel();
		if (view.getEAnnotation("Shortcut") != null) { //$NON-NLS-1$
			req.setElementToDestroy(view);
		}
		cc.add(getGEFWrapper(new DestroyElementCommand(req)));
		return cc.unwrap();
	}

	/**
	 * @generated
	 */
	protected void addDestroyChildNodesCommand(CompoundCommand cmd) {
		View view = (View) getHost().getModel();
		EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
		if (annotation != null) {
			return;
		}
		for (Iterator it = view.getChildren().iterator(); it.hasNext();) {
			Node node = (Node) it.next();
			switch (IpacadlVisualIDRegistry.getVisualID(node)) {
			case BooleanLiteral2EditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			case DoubleLiteral2EditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			case IntegerLiteral2EditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			case StringLiteral2EditPart.VISUAL_ID:
				cmd.add(getDestroyElementCommand(node));
				break;
			}
		}
	}

}
