package eu.ipac.ace.gmf.ipacadl.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

import eu.ipac.ace.gmf.ipacadl.diagram.edit.policies.InvokeStatement2CanonicalEditPolicy;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.policies.InvokeStatement2ItemSemanticEditPolicy;
import eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry;

/**
 * @generated
 */
public class InvokeStatement2EditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 2007;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public InvokeStatement2EditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		installEditPolicy(EditPolicyRoles.CREATION_ROLE,
				new CreationEditPolicy());
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new InvokeStatement2ItemSemanticEditPolicy());
		installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE,
				new DragDropEditPolicy());
		installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
				new InvokeStatement2CanonicalEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child
						.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		InvokeStatementFigure figure = new InvokeStatementFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public InvokeStatementFigure getPrimaryShape() {
		return (InvokeStatementFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof InvokeStatementComponentName2EditPart) {
			((InvokeStatementComponentName2EditPart) childEditPart)
					.setLabel(getPrimaryShape()
							.getFigureInvokeComponentNameLabel());
			return true;
		}
		if (childEditPart instanceof InvokeStatementMethodName2EditPart) {
			((InvokeStatementMethodName2EditPart) childEditPart)
					.setLabel(getPrimaryShape()
							.getFigureInvokeMethodNameLabel());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {

		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {

		return super.getContentPaneFor(editPart);
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(getMapMode()
				.DPtoLP(-1), getMapMode().DPtoLP(-1));
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(getMapMode().DPtoLP(5));
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(IpacadlVisualIDRegistry
				.getType(InvokeStatementComponentName2EditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public class InvokeStatementFigure extends RectangleFigure {

		/**
		 * @generated
		 */
		private WrappingLabel fFigureInvokeComponentNameLabel;
		/**
		 * @generated
		 */
		private WrappingLabel fFigureInvokeMethodNameLabel;

		/**
		 * @generated
		 */
		public InvokeStatementFigure() {
			this.setForegroundColor(ColorConstants.black);
			this.setBackgroundColor(ColorConstants.white);

			this.setFont(THIS_FONT);

			this.setMaximumSize(new Dimension(getMapMode().DPtoLP(20),
					getMapMode().DPtoLP(40)));

			this.setBorder(new MarginBorder(getMapMode().DPtoLP(3),
					getMapMode().DPtoLP(3), getMapMode().DPtoLP(3),
					getMapMode().DPtoLP(3)));
			createContents();
		}

		/**
		 * @generated NOT
		 */
		private void createContents() {

			String creationToolsDescription = eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlPaletteFactory.descriptionOfEachCreationTool;
			String theNameOfService = null;
			String theNameOfMethod = null;
			boolean startsWith = false;
			if(creationToolsDescription == null){
				startsWith = false;
			}
			else{
				startsWith = creationToolsDescription.startsWith("Service: ");
			}
			if(startsWith){
				int positionOfComma = creationToolsDescription.indexOf(", ");
				theNameOfService = creationToolsDescription.substring(9, positionOfComma);
				theNameOfMethod = creationToolsDescription.substring(positionOfComma+10);
			}

			fFigureInvokeComponentNameLabel = new WrappingLabel();
			
			if(startsWith){
				fFigureInvokeComponentNameLabel.setText(theNameOfService);
			}
			else{
				fFigureInvokeComponentNameLabel.setText("<Component Name>");
				theNameOfService = "<Component Name>";
			}
			
			fFigureInvokeComponentNameLabel.setText("<Component Name>");

			this.add(fFigureInvokeComponentNameLabel);

			fFigureInvokeMethodNameLabel = new WrappingLabel();
			
			if(startsWith){
				fFigureInvokeMethodNameLabel.setText(theNameOfMethod);
			}
			else{
				fFigureInvokeMethodNameLabel.setText("<Method Name>");
			}
			
			fFigureInvokeMethodNameLabel.setText("<Method Name>");

			this.add(fFigureInvokeMethodNameLabel);

		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureInvokeComponentNameLabel() {
			return fFigureInvokeComponentNameLabel;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureInvokeMethodNameLabel() {
			return fFigureInvokeMethodNameLabel;
		}

	}

	/**
	 * @generated
	 */
	static final Font THIS_FONT = new Font(Display.getCurrent(), Display
			.getDefault().getSystemFont().getFontData()[0].getName(), 7,
			SWT.NORMAL);

}
