package eu.ipac.ace.gmf.ipacadl.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

import eu.ipac.ace.gmf.ipacadl.diagram.edit.policies.IfStatement4ItemSemanticEditPolicy;
import eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlVisualIDRegistry;
import eu.ipac.ace.gmf.ipacadl.diagram.providers.IpacadlElementTypes;

/**
 * @generated
 */
public class IfStatement4EditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 2031;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public IfStatement4EditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		installEditPolicy(EditPolicyRoles.CREATION_ROLE,
				new CreationEditPolicy() {
					public Command getCommand(Request request) {
						if (understandsRequest(request)) {
							if (request instanceof CreateViewAndElementRequest) {
								CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest) request)
										.getViewAndElementDescriptor()
										.getCreateElementRequestAdapter();
								IElementType type = (IElementType) adapter
										.getAdapter(IElementType.class);
								if (type == IpacadlElementTypes.Expression_2015) {
									EditPart compartmentEditPart = getChildBySemanticHint(IpacadlVisualIDRegistry
											.getType(IfStatementCompartmentIfExpression4EditPart.VISUAL_ID));
									return compartmentEditPart == null ? null
											: compartmentEditPart
													.getCommand(request);
								}
							}
							return super.getCommand(request);
						}
						return null;
					}
				});
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new IfStatement4ItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child
						.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		IfStatementFigure figure = new IfStatementFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public IfStatementFigure getPrimaryShape() {
		return (IfStatementFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof IfStatementCompartmentIfExpression4EditPart) {
			IFigure pane = getPrimaryShape().getFigureCompartmentIfExpression();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.add(((IfStatementCompartmentIfExpression4EditPart) childEditPart)
							.getFigure());
			return true;
		}
		if (childEditPart instanceof IfStatementCompartmentIfStatement4EditPart) {
			IFigure pane = getPrimaryShape().getFigureCompartmentIfStaments();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.add(((IfStatementCompartmentIfStatement4EditPart) childEditPart)
							.getFigure());
			return true;
		}
		if (childEditPart instanceof IfStatementCompartmentElseStatement4EditPart) {
			IFigure pane = getPrimaryShape()
					.getFigureCompartmentElseStatements();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.add(((IfStatementCompartmentElseStatement4EditPart) childEditPart)
							.getFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {

		if (childEditPart instanceof IfStatementCompartmentIfExpression4EditPart) {
			IFigure pane = getPrimaryShape().getFigureCompartmentIfExpression();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.remove(((IfStatementCompartmentIfExpression4EditPart) childEditPart)
							.getFigure());
			return true;
		}
		if (childEditPart instanceof IfStatementCompartmentIfStatement4EditPart) {
			IFigure pane = getPrimaryShape().getFigureCompartmentIfStaments();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.remove(((IfStatementCompartmentIfStatement4EditPart) childEditPart)
							.getFigure());
			return true;
		}
		if (childEditPart instanceof IfStatementCompartmentElseStatement4EditPart) {
			IFigure pane = getPrimaryShape()
					.getFigureCompartmentElseStatements();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.remove(((IfStatementCompartmentElseStatement4EditPart) childEditPart)
							.getFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {

		if (editPart instanceof IfStatementCompartmentIfExpression4EditPart) {
			return getPrimaryShape().getFigureCompartmentIfExpression();
		}
		if (editPart instanceof IfStatementCompartmentIfStatement4EditPart) {
			return getPrimaryShape().getFigureCompartmentIfStaments();
		}
		if (editPart instanceof IfStatementCompartmentElseStatement4EditPart) {
			return getPrimaryShape().getFigureCompartmentElseStatements();
		}
		return super.getContentPaneFor(editPart);
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(getMapMode()
				.DPtoLP(-1), getMapMode().DPtoLP(-1));
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(getMapMode().DPtoLP(5));
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	public class IfStatementFigure extends RoundedRectangle {

		/**
		 * @generated
		 */
		private RectangleFigure fFigureCompartmentIfExpression;
		/**
		 * @generated
		 */
		private RoundedRectangle fFigureCompartmentIfStaments;
		/**
		 * @generated
		 */
		private RoundedRectangle fFigureCompartmentElseStatements;

		/**
		 * @generated
		 */
		public IfStatementFigure() {
			this.setCornerDimensions(new Dimension(getMapMode().DPtoLP(8),
					getMapMode().DPtoLP(8)));
			this.setForegroundColor(ColorConstants.black);
			this.setBackgroundColor(ColorConstants.white);

			this.setFont(THIS_FONT);

			this.setMinimumSize(new Dimension(getMapMode().DPtoLP(20),
					getMapMode().DPtoLP(40)));
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			fFigureCompartmentIfExpression = new RectangleFigure();
			fFigureCompartmentIfExpression
					.setForegroundColor(ColorConstants.black);
			fFigureCompartmentIfExpression
					.setBackgroundColor(ColorConstants.orange);
			fFigureCompartmentIfExpression.setMaximumSize(new Dimension(
					getMapMode().DPtoLP(10000), getMapMode().DPtoLP(50)));

			this.add(fFigureCompartmentIfExpression);

			WrappingLabel ifExpressionLabel1 = new WrappingLabel();
			ifExpressionLabel1.setText("IF");
			ifExpressionLabel1.setForegroundColor(ColorConstants.black);
			ifExpressionLabel1.setBackgroundColor(ColorConstants.orange);

			ifExpressionLabel1.setFont(IFEXPRESSIONLABEL1_FONT);

			ifExpressionLabel1.setMaximumSize(new Dimension(getMapMode()
					.DPtoLP(10000), getMapMode().DPtoLP(20)));

			fFigureCompartmentIfExpression.add(ifExpressionLabel1);

			fFigureCompartmentIfStaments = new RoundedRectangle();
			fFigureCompartmentIfStaments.setCornerDimensions(new Dimension(
					getMapMode().DPtoLP(8), getMapMode().DPtoLP(8)));
			fFigureCompartmentIfStaments
					.setForegroundColor(ColorConstants.black);
			fFigureCompartmentIfStaments
					.setBackgroundColor(ColorConstants.white);

			fFigureCompartmentIfStaments
					.setFont(FFIGURECOMPARTMENTIFSTAMENTS_FONT);

			this.add(fFigureCompartmentIfStaments);

			WrappingLabel ifStatementsLabel1 = new WrappingLabel();
			ifStatementsLabel1.setText("THEN");
			ifStatementsLabel1.setForegroundColor(ColorConstants.black);
			ifStatementsLabel1.setBackgroundColor(ColorConstants.orange);

			ifStatementsLabel1.setFont(IFSTATEMENTSLABEL1_FONT);

			ifStatementsLabel1.setMaximumSize(new Dimension(getMapMode()
					.DPtoLP(300), getMapMode().DPtoLP(20)));

			fFigureCompartmentIfStaments.add(ifStatementsLabel1);

			fFigureCompartmentElseStatements = new RoundedRectangle();
			fFigureCompartmentElseStatements.setCornerDimensions(new Dimension(
					getMapMode().DPtoLP(8), getMapMode().DPtoLP(8)));
			fFigureCompartmentElseStatements
					.setForegroundColor(ColorConstants.black);
			fFigureCompartmentElseStatements
					.setBackgroundColor(ColorConstants.white);

			fFigureCompartmentElseStatements
					.setFont(FFIGURECOMPARTMENTELSESTATEMENTS_FONT);

			this.add(fFigureCompartmentElseStatements);

			WrappingLabel elseStatementsLabel1 = new WrappingLabel();
			elseStatementsLabel1.setText("ELSE");
			elseStatementsLabel1.setForegroundColor(ColorConstants.black);
			elseStatementsLabel1.setBackgroundColor(ColorConstants.orange);

			elseStatementsLabel1.setFont(ELSESTATEMENTSLABEL1_FONT);

			elseStatementsLabel1.setMaximumSize(new Dimension(getMapMode()
					.DPtoLP(300), getMapMode().DPtoLP(20)));

			fFigureCompartmentElseStatements.add(elseStatementsLabel1);

		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public RectangleFigure getFigureCompartmentIfExpression() {
			return fFigureCompartmentIfExpression;
		}

		/**
		 * @generated
		 */
		public RoundedRectangle getFigureCompartmentIfStaments() {
			return fFigureCompartmentIfStaments;
		}

		/**
		 * @generated
		 */
		public RoundedRectangle getFigureCompartmentElseStatements() {
			return fFigureCompartmentElseStatements;
		}

	}

	/**
	 * @generated
	 */
	static final Font THIS_FONT = new Font(Display.getCurrent(), Display
			.getDefault().getSystemFont().getFontData()[0].getName(), 7,
			SWT.NORMAL);

	/**
	 * @generated
	 */
	static final Font IFEXPRESSIONLABEL1_FONT = new Font(Display.getCurrent(),
			Display.getDefault().getSystemFont().getFontData()[0].getName(), 7,
			SWT.BOLD);

	/**
	 * @generated
	 */
	static final Font FFIGURECOMPARTMENTIFSTAMENTS_FONT = new Font(Display
			.getCurrent(),
			Display.getDefault().getSystemFont().getFontData()[0].getName(),
			12, SWT.NORMAL);

	/**
	 * @generated
	 */
	static final Font IFSTATEMENTSLABEL1_FONT = new Font(Display.getCurrent(),
			Display.getDefault().getSystemFont().getFontData()[0].getName(), 7,
			SWT.BOLD);

	/**
	 * @generated
	 */
	static final Font FFIGURECOMPARTMENTELSESTATEMENTS_FONT = new Font(Display
			.getCurrent(),
			Display.getDefault().getSystemFont().getFontData()[0].getName(),
			12, SWT.NORMAL);

	/**
	 * @generated
	 */
	static final Font ELSESTATEMENTSLABEL1_FONT = new Font(
			Display.getCurrent(), Display.getDefault().getSystemFont()
					.getFontData()[0].getName(), 7, SWT.BOLD);

}
