package eu.ipac.ace.gmf.ipacadl.diagram.edit.commands;

import java.util.List;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.ui.PlatformUI;

import eu.ipac.ace.gmf.ipacadl.CaseStatement;
import eu.ipac.ace.gmf.ipacadl.EntryPoint;
import eu.ipac.ace.gmf.ipacadl.Statement;
import eu.ipac.ace.gmf.ipacadl.diagram.edit.policies.IpacadlBaseItemSemanticEditPolicy;
import eu.ipac.ace.gmf.ipacadl.diagram.part.IpacadlDiagramEditor;
import eu.ipac.ace.gmf.ipacadl.impl.BodyImpl;
import eu.ipac.ace.gmf.ipacadl.impl.CaseStatementImpl;
import eu.ipac.ace.gmf.ipacadl.impl.DefaultStatementImpl;
import eu.ipac.ace.gmf.ipacadl.impl.EntryPointImpl;
import eu.ipac.ace.gmf.ipacadl.impl.FaultStatementImpl;
import eu.ipac.ace.gmf.ipacadl.impl.IfStatementImpl;
import eu.ipac.ace.gmf.ipacadl.impl.IterationStatementImpl;

/**
 * @generated
 */
public class StatementConnectionCreateCommand extends EditElementCommand {

	/**
	 * @generated
	 */
	private final EObject source;

	/**
	 * @generated
	 */
	private final EObject target;

	/**
	 * @generated
	 */
	public StatementConnectionCreateCommand(CreateRelationshipRequest request,
			EObject source, EObject target) {
		super(request.getLabel(), null, request);
		this.source = source;
		this.target = target;
	}

	/**
	 * @generated
	 */
	public boolean canExecute() {
		if (source == null && target == null) {
			return false;
		}
		if (source != null && false == source instanceof Statement) {
			return false;
		}
		if (target != null && false == target instanceof Statement) {
			return false;
		}
		if (getSource() == null) {
			return true; // link creation is in progress; source is not defined yet
		}
		// target may be null here but it's possible to check constraint
		return IpacadlBaseItemSemanticEditPolicy.LinkConstraints
				.canCreateStatementConnection_3001(getSource(), getTarget());
	}

	/**
	 * @generated NOT
	 */
	protected CommandResult doExecuteWithResult(IProgressMonitor monitor,
			IAdaptable info) throws ExecutionException {
		if (!canExecute()) {
			throw new ExecutionException(
					"Invalid arguments in create link command"); //$NON-NLS-1$
		}
		if (getSource() != null && getTarget() != null) {
			/***************************************************************************************/
			EObject SourceObject = getSource();
			EObject parentOfSource = SourceObject.eContainer();
			EObject TargetObject = getTarget();
			EObject parentOfTarget = TargetObject.eContainer();
			Resource dummyResource = TargetObject.eResource();
			TreeIterator<EObject> dummyTreeIterator = dummyResource.getAllContents();
			EList ListOfStatements = null;
			EObject testElement = dummyTreeIterator.next();
			if(parentOfSource.equals(parentOfTarget)){
				while(testElement!=null){
					/*Scan through all element instances*/
					if((testElement instanceof BodyImpl) ||
					   (testElement instanceof IterationStatementImpl) ||
					   (testElement instanceof IfStatementImpl) ||
					   (testElement instanceof FaultStatementImpl)){
						int indication = 0;
						if(testElement instanceof BodyImpl){
							ListOfStatements = ((BodyImpl) testElement).getStatements();
							indication = 1;
						}
						else if(testElement instanceof IterationStatementImpl){
							ListOfStatements = ((IterationStatementImpl) testElement).getWhileStatements();
							indication = 1;
						}
						else if(testElement instanceof IfStatementImpl){
							ListOfStatements = ((IfStatementImpl) testElement).getIfStatements();
							indication = 2;
						}
						else if(testElement instanceof FaultStatementImpl){
							ListOfStatements = ((FaultStatementImpl) testElement).getFStatements();
							indication = 1;
						}
						for (int index=1; index<=indication; index++){
							if(index==2){
								ListOfStatements = ((IfStatementImpl) testElement).getElseStatements();
							}
							if (!ListOfStatements.isEmpty()){
							//Simple SWAP Procedure
								//testElement.eSetDeliver(false);				
								//int sourceIndex = ListOfStatements.indexOf(SourceObject);
								//int targetIndex = ListOfStatements.indexOf(TargetObject);
								//Object swapObject = ListOfStatements.get(sourceIndex);
								//ListOfStatements.move(sourceIndex, targetIndex);
								//ListOfStatements.move(targetIndex, swapObject);
							//Advanced FLOW Procedure
								/***Save List of Statements***/
								int [] ArrayOfObject = new int[ListOfStatements.size()]; 
								Object[] listOfObjects = ListOfStatements.toArray();
								int sourceIndex = ListOfStatements.indexOf(SourceObject);
								int targetIndex = ListOfStatements.indexOf(TargetObject);
								/***Save pointers of each Statement***/
								for (int i=0; i<ListOfStatements.size(); i++){
									if (i==sourceIndex){
										ArrayOfObject[i]=targetIndex;
									}
									else{
										Object currentObject = listOfObjects[i];
										Statement targetStatement = ((Statement) currentObject).getConnection();
										ArrayOfObject[i]=ListOfStatements.indexOf((Object)targetStatement);
									}
								}
								/***Find Statements having no arrow as target and source***/
								/***And Statements placed last in an arrow sequence********/
								int [] objectHavingNoArrow = new int[ListOfStatements.size()]; 
								int [] objectPlacedLastInArrowSequence = new int[ListOfStatements.size()]; 
								for (int k=0; k<ListOfStatements.size(); k++){
									objectHavingNoArrow[k]=0;
									objectPlacedLastInArrowSequence[k]=0;
								}
								int countElementsWithNoArrow = 0;
								int countElementsLastInArrowSequence = 0;
								for (int i=0; i<ListOfStatements.size(); i++){
									if(ArrayOfObject[i]==-1){
										int noArrowIndex = 0;
										for(int j=0; j<ListOfStatements.size(); j++){
											if(ArrayOfObject[j]==i){
												noArrowIndex = 1;
											}
										}
										if(noArrowIndex==0){
											countElementsWithNoArrow++;
											objectHavingNoArrow[i]=1;
										}
										else{
											countElementsLastInArrowSequence++;
											objectPlacedLastInArrowSequence[i]=1;
										}
									}
								}
								/***Search if an element is referenced by 2 or more elements***/
								boolean elementReferencedBy2OrMoreElements = false;
								int [] NoOfReferencesInOneElement = new int[ListOfStatements.size()]; 
								for (int k=0; k<ListOfStatements.size(); k++){
									NoOfReferencesInOneElement[k]=0;
								}
								for (int w=0; w<ListOfStatements.size(); w++){
									if(ArrayOfObject[w]!=-1){
										NoOfReferencesInOneElement[ArrayOfObject[w]]++;
									}
								}
								for(int x=0; x<ListOfStatements.size(); x++){
									if(NoOfReferencesInOneElement[x]>1){
										elementReferencedBy2OrMoreElements = true;
										IpacadlDiagramEditor editor = (IpacadlDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
										DiagramEditPart editorsDiagramEditPart = editor.getDiagramEditPart();
										List connectionsOfTheModel = editorsDiagramEditPart.getConnections();
										for (int l=0; l<connectionsOfTheModel.size(); l++){
											Object eachConnection = connectionsOfTheModel.get(l);
											if(eachConnection instanceof ConnectionEditPart){
												((ConnectionEditPart) eachConnection).getFigure().setForegroundColor(ColorConstants.red);
											}
										}
										getSource().setConnection(getTarget());
										return CommandResult.newOKCommandResult();
									}
								}
								
								/***Place Elements in the correct order starting from***/
								/***Statements having no arrow as target and source*****/
								int [] UpdatedArrayOfObject = new int[ListOfStatements.size()]; 
								for (int k=0; k<ListOfStatements.size(); k++){
									UpdatedArrayOfObject[k]=0;
								}
								if((countElementsWithNoArrow==ListOfStatements.size()) ||
								   (elementReferencedBy2OrMoreElements==true)){
									//Do nothing: No arrow is created
								}
								else{
									//Paint all arrows the default color (black)
									IpacadlDiagramEditor editor = (IpacadlDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
									DiagramEditPart editorsDiagramEditPart = editor.getDiagramEditPart();
									List connectionsOfTheModel = editorsDiagramEditPart.getConnections();
									for (int l=0; l<connectionsOfTheModel.size(); l++){
										Object eachConnection = connectionsOfTheModel.get(l);
										if(eachConnection instanceof ConnectionEditPart){
											((ConnectionEditPart) eachConnection).getFigure().setForegroundColor(ColorConstants.black);
										}	
									}
									//Place unArrowed elements last
									for (int m=ListOfStatements.size()-1; m>=ListOfStatements.size()-countElementsWithNoArrow; m--){
										for(int n=0; n<ListOfStatements.size(); n++){
											if(objectHavingNoArrow[n]==1){
												UpdatedArrayOfObject[m]=n;
												objectHavingNoArrow[n]=0;
												break;
											}
										}
									}
									if(countElementsLastInArrowSequence==1){
										//Place only one sequence of elements
										for (int l=0; l<ListOfStatements.size(); l++){
											if(objectPlacedLastInArrowSequence[l]==1){
												UpdatedArrayOfObject[ListOfStatements.size()-countElementsWithNoArrow-1]=l;
											}
										}
										//Place all other elements in the correct order
										for (int p=ListOfStatements.size()-countElementsWithNoArrow-2; p>=0; p--){
											int indexOfPreviousElement = -1;
											for (int q=0; q<ListOfStatements.size(); q++){
												if(ArrayOfObject[q]==UpdatedArrayOfObject[p+1]){
													indexOfPreviousElement=q;
												}
											}
											UpdatedArrayOfObject[p]=indexOfPreviousElement;
										}
										//Copy the appropriate Statements in the correct order
										int sizeOfStatementList = ListOfStatements.size();
										testElement.eSetDeliver(false);	
										ListOfStatements.clear();
										for (int r=0; r<sizeOfStatementList; r++){
											ListOfStatements.add(listOfObjects[UpdatedArrayOfObject[r]]);
										}
										testElement.eSetDeliver(true);
									}
									else{
										break;
									}
								}
							}
						}
					}
					//Check if checks must finish
					if(dummyTreeIterator.hasNext()){
						testElement = dummyTreeIterator.next();
					}
					else{
						break;
					}
				}
			}
			else{
				IpacadlDiagramEditor editor = (IpacadlDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
				DiagramEditPart editorsDiagramEditPart = editor.getDiagramEditPart();
				List connectionsOfTheModel = editorsDiagramEditPart.getConnections();
				for (int l=0; l<connectionsOfTheModel.size(); l++){
					Object eachConnection = connectionsOfTheModel.get(l);
					if(eachConnection instanceof ConnectionEditPart){
						((ConnectionEditPart) eachConnection).getFigure().setForegroundColor(ColorConstants.red);
					}
				}
			}
			/***************************************************************************************/
			
			getSource().setConnection(getTarget());
		}
		return CommandResult.newOKCommandResult();
	}

	/**
	 * @generated
	 */
	protected Statement getSource() {
		return (Statement) source;
	}

	/**
	 * @generated
	 */
	protected Statement getTarget() {
		return (Statement) target;
	}
}
