/*
 * PropertiesTable.java
 * 
 * Version 1.0
 *
 * 19-3-2009
 * 
 * Ipac Consortium
 */
package eu.ipac.ace.ape.views;

import eu.ipac.ace.utils.*;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import com.ugos.JIProlog.engine.*;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;


/**
 * PropertiesTable shows the table which will be completed by the developer and will result
 * the Ipac application profile
 * @version 	1.0 19 Mar 2009
 * @author 	
 */

public class PropertiesTable {
	TableViewer tableViewer;
	//static String[] genAttributes = {"ID", "usesSensor", "usesUITemplate", "Version", "supportsGroup", 
	//		  "Group", "Criticality", "requiresStorage", "requiresUI", "requiresCommRange"};
	static String[] genAttributes = {"ID", "Name", "usesSensor", "Version", "supportsGroup", 
		  "Group", "Criticality", "requiresStorage", "requiresUI", "requiresCommRange"};
	static String[] criticalityAtts = {"Very High", "High", "Medium", "Low", "Very Low"};
	static String[] UIAtts = {"Textual", "Visual", "Sound"};
	ArrayList<String> sensorAtts = new ArrayList<String>();
	static Composite composite;
	static Long idNumber;
	static String id;
	ArrayList<String> sensorProps = new ArrayList<String>();
	static String[] operators = {"==", "!=", ">", ">=", "<", "<="};
	static ArrayList<ProfileItem> tableItems = new ArrayList<ProfileItem>();
	boolean newApp;
	String oldAppID = "";
	String appFileName = "";
	
	// Path to external files!
	private static final String IPAC_PATH = "C://IPAC_ROOT//";
	private static final String APP_PROFILE_EDITOR_PATH = "Models//"; 
	//private static final String IDS_FILE = "IDs.txt";
	private static final String SENSOR_MODEL_FILE = "profile_sensor.pl";
	
	private static final String APP_PROFILE_FILE_EXTENSION = ".pl";
	
	private static String applicationID = "";
	
	/*private JIPEngine engine = new JIPEngine();
	private JIPTermParser termParser = engine.getTermParser();;*/
	
	public PropertiesTable(final Display display, final Composite composite1) {
		//Old id
		try {
			id = InetAddress.getLocalHost().getHostName()+"_Ipac_App_";
			id = id.replaceAll("-", "_");
		}
		catch (Exception e) {
			id = "Ipac_App_";
		}
		final org.eclipse.swt.graphics.Color eventNameColor = new org.eclipse.swt.graphics.Color(display, new RGB(200,200,250));
		final org.eclipse.swt.graphics.Color conditionColor = new org.eclipse.swt.graphics.Color(display, new RGB(200,200,200));
		final org.eclipse.swt.graphics.Font eventFont = new org.eclipse.swt.graphics.Font(display, new FontData("Courier", 8, SWT.BOLD));
		final org.eclipse.swt.graphics.Color labelColor = new org.eclipse.swt.graphics.Color(display, new RGB(247,247,247)); 
		final org.eclipse.swt.graphics.Font appLabelFont = new org.eclipse.swt.graphics.Font(display, new FontData("Courier", 9, SWT.BOLD));
		final org.eclipse.swt.graphics.Color appStoredColor = new org.eclipse.swt.graphics.Color(display, new RGB(247,100,100)); 
		//Read the sensor model and fill the sensorAtts table
		//Call the text file parser and read the contents
		sensorAtts = this.getSensorTypes();
		//sensorProps = this.getProperties();
		newApp = true;		
		
		/*//Initialize JIProlog engine
		initializeJIProlog();*/
		
		//Build the application window
	    final Shell shell = new Shell(display, SWT.SHELL_TRIM | SWT.H_SCROLL | SWT.V_SCROLL);
	    shell.setSize(900, 760);
	    shell.setLocation(200, -10);
//	    shell.setMaximized(true);
	    shell.setLayout(new RowLayout());
	    shell.setText("IPAC Application Profile Editor");
	    
	    final Composite composite = new Composite(shell, SWT.NONE);
	    
	    //listeners for scrolling the main window
	    final ScrollBar hBar = shell.getHorizontalBar ();
		hBar.addListener (SWT.Selection, new Listener () {
			public void handleEvent (org.eclipse.swt.widgets.Event e) {
				Point location = composite.getLocation ();
				location.x = -hBar.getSelection ();
				composite.setLocation (location);
			}
		});
		final ScrollBar vBar = shell.getVerticalBar ();
		vBar.addListener (SWT.Selection, new Listener () {
			public void handleEvent (org.eclipse.swt.widgets.Event e) {
				Point location = composite.getLocation ();
				location.y = -vBar.getSelection ();
				composite.setLocation (location);
			}
		});
		shell.addListener (SWT.Resize,  new Listener () {
			public void handleEvent (org.eclipse.swt.widgets.Event e) {
				Point size = composite.getSize ();
				Rectangle rect = shell.getClientArea ();
				hBar.setMaximum (size.x);
				vBar.setMaximum (size.y);
				hBar.setThumb (Math.min (size.x, rect.width));
				vBar.setThumb (Math.min (size.y, rect.height));
				int hPage = size.x - rect.width;
				int vPage = size.y - rect.height;
				int hSelection = hBar.getSelection ();
				int vSelection = vBar.getSelection ();
				Point location = composite.getLocation ();
				if (hSelection >= hPage) {
					if (hPage <= 0) hSelection = 0;
					location.x = -hSelection;
				}
				if (vSelection >= vPage) {
					if (vPage <= 0) vSelection = 0;
					location.y = -vSelection;
				}
				composite.setLocation (location);
			}
		});
		//end of listeners for scrolling
	    
	    ///End of main Menu component
	    GridLayout gridLayout = new GridLayout();
	    gridLayout.numColumns = 1;
	    composite.setLayout(gridLayout);
	    
	    final Composite composite_up = new Composite(composite, SWT.NONE);
	    GridLayout gridLayout_up = new GridLayout();
	    gridLayout_up.numColumns = 1;
	    composite_up.setLayout(gridLayout_up);
	    
	    Label label_up = new Label(composite_up, SWT.SHADOW_NONE);
	    org.eclipse.swt.graphics.Font label_font = new org.eclipse.swt.graphics.Font(display, new FontData("Courier", 10, SWT.BOLD));
	    label_up.setFont(label_font);
	    label_up.setText("Generic Application Information");
	    //FIRST TABLE
	    final int style = SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.HIDE_SELECTION;
	    final Table genTable = new Table(composite_up, style);
	    GridData tableGrid = new GridData(GridData.FILL_BOTH);
	    tableGrid.grabExcessVerticalSpace = true;
	    tableGrid.horizontalSpan = 2;
	    genTable.setLayoutData(tableGrid);		
		
	    genTable.setLinesVisible(true);
	    genTable.setHeaderVisible(true);

	    TableColumn column1 = new TableColumn(genTable, SWT.CENTER, 0);		
		column1.setText("Name of Property");
		column1.setWidth(200);
		column1 = new TableColumn(genTable, SWT.CENTER, 1);
		column1.setText("Range");
		column1.setWidth(310);
		column1 = new TableColumn(genTable, SWT.CENTER, 2);
		column1.setText("Sensor ID");
		column1.setWidth(150);
		
		//Deal with the application ID
		//try {
            //BufferedReader idFile = new BufferedReader(new FileReader(IPAC_PATH + APP_PROFILE_EDITOR_PATH + IDS_FILE));
            //idNumber = Long.parseLong(idFile.readLine());
            //idFile.close();
		//} catch (Exception e) { 
		//		System.out.println("Wrong File or Path for File with ID information!"); 
		//	}
		TableItem item;
		for (int i=0; i<genAttributes.length; i++)
		{
			item = new TableItem(genTable, SWT.NONE);
			if (genAttributes[i].equalsIgnoreCase("ID")) {
				//Long idN = idNumber + 1;
				//id += idN;
				id += Calendar.getInstance().getTime();
				//get the final ID
				applicationID = produceID(id);
				//old command
				//item.setText(new String[] { genAttributes[i], id } );
				item.setText(new String[] { genAttributes[i], applicationID } );
				item.setBackground(0, labelColor);
				item.setBackground(1, labelColor);
			}
			else {
				item.setText(new String[] { genAttributes[i], "" } );
				item.setBackground(0, labelColor);
			}
		}
		
		//Define the editor for the first table (generic information)
		final TableEditor editor = new TableEditor(genTable);
		genTable.addMouseListener(new MouseAdapter() {
			public void mouseDown(MouseEvent event) {
				Control old = editor.getEditor();
				if (old != null) old.dispose();
				Point pt = new Point(event.x, event.y);
				final TableItem item = genTable.getItem(pt);
				if (item != null && !item.getText().equalsIgnoreCase("ID")) {
					if (item.getText().equalsIgnoreCase("Criticality")
						|| item.getText().equalsIgnoreCase("requiresUI")
						|| item.getText().equalsIgnoreCase("usesSensor")) {
						int column = -1;
			        	for (int i = 0, n = genTable.getColumnCount(); i < n; i++) {
			        		Rectangle rect = item.getBounds(i);
			        		if (rect.contains(pt)) {
			        				column = i;
			        				break;
			        		}
			        	}
			        	//System.out.println("Column="+column);
			        	if (column == 1) {
			        		final Combo combo = new Combo(genTable, SWT.READ_ONLY);
			        		if (item.getText().equalsIgnoreCase("Criticality")) {
			        			for (int i = 0, n = criticalityAtts.length; i < n; i++) {
				        			combo.add(criticalityAtts[i]);
				        		}
			        		}
			        		else if (item.getText().equalsIgnoreCase("requiresUI")) {
			        			for (int i = 0, n = UIAtts.length; i < n; i++) {
				        			combo.add(UIAtts[i]);
				        		}
			        		}
			        		else if (item.getText().equalsIgnoreCase("usesSensor")) {
			        			for (int i = 0, n = sensorAtts.size(); i < n; i++) {
				        			combo.add((String)sensorAtts.get(i));
				        		}
			        		}
			        		combo.select(combo.indexOf(item.getText(column)));
			        		editor.minimumWidth = 310;
			        		genTable.getColumn(column).setWidth(editor.minimumWidth);
			        		combo.setFocus();
			        		editor.setEditor(combo, item, column);
			        		final int col = column;
			        		combo.addSelectionListener(new SelectionAdapter() {
			        			public void widgetSelected(SelectionEvent event) {
			        				item.setText(col, combo.getText());
			        				combo.dispose();
			        			}
			        		});
			        	}
			        	else {
			        		if (item.getText().equalsIgnoreCase("usesSensor")) {
					        	//Text Editor for the Sensor ID in the Second Column
					        	Text new2Editor = new Text(genTable, SWT.NONE);
					        	new2Editor.setText(item.getText(2));
					        	new2Editor.addModifyListener(new ModifyListener() {
					        		public void modifyText(ModifyEvent me) {
					        			Text text = (Text) editor.getEditor();
					        			editor.getItem().setText(2, text.getText());
					        		}
					        	});
					        	new2Editor.selectAll();
					        	new2Editor.setFocus();
					        	editor.setEditor(new2Editor, item, 2);
			        		}			        		
			        	}
	        		}
					else {
						//Text Editor for the rest parameters
						Text newEditor = new Text(genTable, SWT.NONE);
				        newEditor.setText(item.getText(1));
				        newEditor.addModifyListener(new ModifyListener() {
				        	public void modifyText(ModifyEvent me) {
				        		Text text = (Text) editor.getEditor();
				        		editor.getItem().setText(1, text.getText());
				        	}
				        });
				        newEditor.selectAll();
				        newEditor.setFocus();
				        editor.setEditor(newEditor, item, 1);
					}
				}//if item!=null	
			} //mouseDown
	    });
		
		//Buttons for editing the first table
		final Composite compositeMiddle = new Composite(composite, SWT.NONE);
	    compositeMiddle.setLayout(new FillLayout());
		Button addButtonSensor = new Button(compositeMiddle, SWT.PUSH);
		addButtonSensor.setText("Add Sensor Type");
		addButtonSensor.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem item = new TableItem(genTable, SWT.NONE, 2);
				item.setText(new String[] { "usesSensor", "" } );
				item.setBackground(0, labelColor);
			}
		});
		Button addButtonGroup = new Button(compositeMiddle, SWT.PUSH);
		addButtonGroup.setText("Add Group Definition");
		addButtonGroup.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem[] items = genTable.getItems();
				for (int i=0; i<items.length; i++) {
					if (items[i].getText(0).equalsIgnoreCase("supportsGroup")) {
						TableItem item = new TableItem(genTable, SWT.NONE, i);
						item.setText(new String[] { "supportsGroup", "" } );
						item.setBackground(0, labelColor);
						break;
					}
				}
			}
		});
		Button addButtonUI = new Button(compositeMiddle, SWT.PUSH);
		addButtonUI.setText("Add UI Definition");
		addButtonUI.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem[] items = genTable.getItems();
				for (int i=0; i<items.length; i++) {
					if (items[i].getText(0).equalsIgnoreCase("requiresUI")) {
						TableItem item = new TableItem(genTable, SWT.NONE, i);
						item.setText(new String[] { "requiresUI", "" } );
						item.setBackground(0, labelColor);
						break;
					}
				}
			}
		});
		Button removeButton = new Button(compositeMiddle, SWT.PUSH);
		removeButton.setText("Remove Sensor/Group/UI");
		removeButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem[] items = genTable.getItems();
				int index = genTable.getSelectionIndex();
				TableItem item = genTable.getItem(index);
				int number = 0;
				for (int i=0; i<items.length; i++) {
					if (items[i].getText().equals(item.getText())) 
						number++;
				}
				if ((item.getText().equalsIgnoreCase("usesSensor")
					|| item.getText().equalsIgnoreCase("supportsGroup")
					|| item.getText().equalsIgnoreCase("requiresUI"))
					&& number > 1) {
					genTable.remove(index);
				}
			}
		});
		
	    final Composite composite_down = new Composite(composite, SWT.NONE);
	    GridLayout gridLayout_down = new GridLayout();
	    gridLayout_down.numColumns = 1;
	    composite_down.setLayout(gridLayout_up);
	    Label label_down = new Label(composite_down, SWT.SHADOW_NONE);
	    label_down.setFont(label_font);
	    label_down.setText("Events Definition");
	    
	    //SECOND TABLE
	    final Table eventTable = new Table(composite_down, style);
	    GridData eventGrid = new GridData(GridData.FILL_BOTH);
	    eventGrid.grabExcessVerticalSpace = true;
	    eventGrid.horizontalSpan = 2;
	    eventGrid.heightHint = 300;
	    eventTable.setLayoutData(eventGrid);		
	    eventTable.setLinesVisible(true);
	    eventTable.setHeaderVisible(true);
	    TableColumn ecolumn1 = new TableColumn(eventTable, SWT.CENTER, 0);		
		ecolumn1.setText("Event Name");
		ecolumn1.setWidth(250);
		ecolumn1 = new TableColumn(eventTable, SWT.CENTER, 1);
		ecolumn1.setText("TTL / Condition Left part");
		ecolumn1.setWidth(200);
		ecolumn1 = new TableColumn(eventTable, SWT.CENTER, 2);
		ecolumn1.setText("HTL / Condition Operator");
		ecolumn1.setWidth(200);
		ecolumn1 = new TableColumn(eventTable, SWT.CENTER, 3);
		ecolumn1.setText("Condition Right part");
		ecolumn1.setWidth(200);
		
		//Define the editor for the second table (Event table)
		final TableEditor events = new TableEditor(eventTable);
		eventTable.addMouseListener(new MouseAdapter() {
			public void mouseDown(MouseEvent event) {
				Control old = events.getEditor();
				if (old != null) old.dispose();
				Point pt = new Point(event.x, event.y);
				final TableItem item = eventTable.getItem(pt);
				if (item != null) { // an to onoma (event) den einai null tote editor sto onoma mono
					// alliws treis editors sto condition
					if (!item.getText(0).equals("Condition")) {
						int column = -1;
			        	for (int i = 0, n = eventTable.getColumnCount(); i < n; i++) {
			        		Rectangle rect = item.getBounds(i);
			        		if (rect.contains(pt)) {
			        				column = i;
			        				break;
			        		}
			        	}
			        	//EventName editor
			        	if (column == 0) {
				        	Text newEditor = new Text(eventTable, SWT.NONE);
							newEditor.setText(item.getText(0));
							newEditor.addModifyListener(new ModifyListener() {
							     public void modifyText(ModifyEvent me) {
							        	Text text = (Text) events.getEditor();
							        	events.getItem().setText(0, text.getText());
							        }
							     });
							newEditor.selectAll();
							newEditor.setFocus();
							events.setEditor(newEditor, item, 0);
			        	}
			        	else if (column == 1) {
			        		//TTL editor
							Text TTLEditor = new Text(eventTable, SWT.NONE);
							TTLEditor.setText(item.getText(1));
							TTLEditor.addModifyListener(new ModifyListener() {
							     public void modifyText(ModifyEvent me) {
							        	Text text = (Text) events.getEditor();
							        	events.getItem().setText(1, text.getText());
							        }
							     });
							TTLEditor.selectAll();
							TTLEditor.setFocus();
							events.setEditor(TTLEditor, item, 1);
			        	}
			        	else {
			        		//HTL Eeditor
							Text HTLEditor = new Text(eventTable, SWT.NONE);
							HTLEditor.setText(item.getText(2));
							HTLEditor.addModifyListener(new ModifyListener() {
							     public void modifyText(ModifyEvent me) {
							        	Text text = (Text) events.getEditor();
							        	events.getItem().setText(2, text.getText());
							        }
							     });
							HTLEditor.selectAll();
							HTLEditor.setFocus();
							events.setEditor(HTLEditor, item, 2);
			        	}
					} //alliws bale dyo editors gia ta conditions
					else {
						int column = -1;
			        	for (int i = 0, n = eventTable.getColumnCount(); i < n; i++) {
			        		Rectangle rect = item.getBounds(i);
			        		if (rect.contains(pt)) {
			        				column = i;
			        				break;
			        		}
			        	}
			        	if (column == 1) {
			        		/*final Combo combo = new Combo(eventTable, SWT.READ_ONLY);
			        		for (int i = 0, n = sensorProps.size(); i < n; i++) {
				        		combo.add((String)sensorProps.get(i));
				        	}
			        		combo.select(combo.indexOf(item.getText(column)));
			        		events.minimumWidth = 200;
			        		genTable.getColumn(column).setWidth(editor.minimumWidth);
			        		combo.setFocus();
			        		events.setEditor(combo, item, column);
			        		final int col = column;
			        		combo.addSelectionListener(new SelectionAdapter() {
			        			public void widgetSelected(SelectionEvent event) {
			        				item.setText(col, combo.getText());
			        				combo.dispose();
			        			}
			        		});*/
			        		Text newEditor = new Text(eventTable, SWT.NONE);
							newEditor.setText(item.getText(1));
							newEditor.addModifyListener(new ModifyListener() {
							     public void modifyText(ModifyEvent me) {
							        	Text text = (Text) events.getEditor();
							        	events.getItem().setText(1, text.getText());
							        }
							     });
							newEditor.selectAll();
							newEditor.setFocus();
							events.setEditor(newEditor, item, 1);
			        	}
			        	else if (column == 2) {
			        		final Combo combo1 = new Combo(eventTable, SWT.READ_ONLY);
			        		for (int i = 0, n = operators.length; i < n; i++) {
				        		combo1.add(operators[i]);
				        	}
			        		combo1.select(combo1.indexOf(item.getText(column)));
			        		events.minimumWidth = 200;
			        		eventTable.getColumn(column).setWidth(events.minimumWidth);
			        		combo1.setFocus();
			        		events.setEditor(combo1, item, column);
			        		final int col = column;
			        		combo1.addSelectionListener(new SelectionAdapter() {
			        			public void widgetSelected(SelectionEvent event) {
			        				item.setText(col, combo1.getText());
			        				combo1.dispose();
			        			}
			        		});
						}
			        	else if (column == 3 ) {
			        		Text newEditor = new Text(eventTable, SWT.NONE);
							newEditor.setText(item.getText(3));
							newEditor.addModifyListener(new ModifyListener() {
							     public void modifyText(ModifyEvent me) {
							        	Text text = (Text) events.getEditor();
							        	events.getItem().setText(3, text.getText());
							        }
							     });
							newEditor.selectAll();
							newEditor.setFocus();
							events.setEditor(newEditor, item, 3);
			        	}
					}	
				}
			}
	    });
		
		//THIRD COMPOSITE FOR BUTTONS
		final Composite buttons_composite = new Composite(composite, SWT.NONE);
	    buttons_composite.setLayout(new FillLayout());
	    //Add a new Event
		Button newEvent = new Button( buttons_composite, SWT.PUSH | SWT.CENTER );
		newEvent.setText("Add Event");
		newEvent.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem item = new TableItem(eventTable, SWT.NONE);
				item.setText(new String[] { "", "", "", "" } );
				item.setBackground(0, eventNameColor);
				item.setFont(eventFont);
			}
		});
		Button deleteEvent = new Button( buttons_composite, SWT.PUSH | SWT.CENTER  );
		deleteEvent.setText("Delete Event");
		deleteEvent.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				int index = eventTable.getSelectionIndex();
				if (index != -1) {
					TableItem item = eventTable.getItem(index);
					if (!item.getText(0).equalsIgnoreCase("Condition") && index != eventTable.getItemCount()-1) {
						if (!eventTable.getItem(index+1).getText().equalsIgnoreCase("Condition"))
							eventTable.remove(index);
					}
					if (index == eventTable.getItemCount()-1)
						eventTable.remove(index);
				}
			}
		});
		
		Button newCondition = new Button( buttons_composite, SWT.PUSH | SWT.CENTER );
		newCondition.setText("Add Condition");
		newCondition.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				int index = eventTable.getSelectionIndex();
				if (index != -1) {
					TableItem item = eventTable.getItem(index);
					if (!item.getText(0).equalsIgnoreCase("")) {
						TableItem itemInserted = new TableItem(eventTable, SWT.NONE, index+1);
						itemInserted.setText(new String[] { "Condition", "", "", "" } );
						itemInserted.setBackground(0, conditionColor);
					}
				}
			}
		});
		
		Button deleteCondition = new Button( buttons_composite, SWT.PUSH | SWT.CENTER  );
		deleteCondition.setText("Delete Condition");
		deleteCondition.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				int index = eventTable.getSelectionIndex();
				if (index != -1) {
					TableItem item = eventTable.getItem(index);
					if (item.getText(0).equalsIgnoreCase("Condition")) {
							eventTable.remove(index);
					}
				}
			}
		});
		
		final Composite footer = new Composite(composite, SWT.NONE);
	    footer.setLayout(new FillLayout());
		final Label appStored = new Label(footer, SWT.NONE);
		appStored.setFont(appLabelFont);
		appStored.setText("The Application Profile is stored in the disk!");
		appStored.setBackground(appStoredColor);
		appStored.setVisible(false);
		
	    final Menu menu = new Menu(shell, SWT.BAR);
	    final MenuItem appItem = new MenuItem(menu, SWT.CASCADE);
	    appItem.setText("Application");
	    MenuItem helpItem = new MenuItem(menu, SWT.CASCADE);
	    helpItem.setText("Help");
	    
	    final Menu appMenu = new Menu(menu);
	    appItem.setMenu(appMenu);
	    MenuItem newItem = new MenuItem(appMenu, SWT.NONE);
	    newItem.setText("New");
	    MenuItem openItem = new MenuItem(appMenu, SWT.CASCADE);
	    openItem.setText("Open");
	    MenuItem exitItem = new MenuItem(appMenu, SWT.NONE);
	    exitItem.setText("Exit");

	    Menu helpMenu = new Menu(menu);
	    helpItem.setMenu(helpMenu);
	    MenuItem aboutItem = new MenuItem(helpMenu, SWT.NONE);
	    aboutItem.setText("About");
	    //Add Listener to Exit selection
	    exitItem.addSelectionListener(new SelectionAdapter() {
		    	public void widgetSelected(SelectionEvent event) {
		    		if (((MenuItem) event.widget).getText().equals("Exit")) {
		    			shell.close();
		    		}
		    	}
	    });
	    //Add Listener to New selection
	    newItem.addSelectionListener(new SelectionAdapter() {
	    	public void widgetSelected(SelectionEvent event) {
	    		if (((MenuItem) event.widget).getText().equals("New")) {
	    			appStored.setVisible(false);
	    			newApp = true;
	    			//Create the initial view of the editor
	    			eventTable.removeAll();
	    			genTable.removeAll();
	    			//try {
	    	        //    BufferedReader idFile = new BufferedReader(new FileReader("IPAC_PATH + APP_PROFILE_EDITOR_PATH + IDS_FILE"));
	    	        //    idNumber = Long.parseLong(idFile.readLine());
	    	        //    idFile.close();
	    			//} catch (Exception e) { 
	    			//		System.out.println("Oupssssss"); 
	    			//	}
	    			TableItem item;
	    			for (int i=0; i<genAttributes.length; i++)
	    			{
	    				item = new TableItem(genTable, SWT.NONE);
	    				if (genAttributes[i].equalsIgnoreCase("ID")) {
	    					//Long idN = idNumber + 1;
	    					try {
								id = InetAddress.getLocalHost().getHostName()+"_Ipac_App_";
								//Long idN = idNumber + 1;
								//id += idN;
								id += Calendar.getInstance().getTime();
								//get the final ID
								applicationID = produceID(id);
								//old command
								//item.setText(new String[] { genAttributes[i], id } );
								item.setText(new String[] { genAttributes[i], applicationID } );
		    					item.setBackground(0, labelColor);
		    					item.setBackground(1, labelColor);
							} catch (UnknownHostException e) {
								// Auto-generated catch block
								e.printStackTrace();
							}
	    				}
	    				else {
	    					item.setText(new String[] { genAttributes[i], "" } );
	    					item.setBackground(0, labelColor);
	    				}
	    			}
	    		}
	    		
	    		
	    	}
	    });
	    //Add Listener to About selection
	    aboutItem.addSelectionListener(new SelectionAdapter() {
	    	public void widgetSelected(SelectionEvent event) {
	    		if (((MenuItem) event.widget).getText().equals("About")) {
	    			appStored.setVisible(false);
	    			//Present helping notes to the developer
	    			Shell helpShell = new Shell();
	    			helpShell.setSize(400, 360);
	    			helpShell.setLocation(400, 200);
	    			helpShell.setLayout(new RowLayout());
	    			helpShell.setText("About Application Profile Editor");
	    		    Composite compoHelp = new Composite(helpShell, SWT.CENTER);   
	    		    GridLayout gridLayout = new GridLayout();
	    		    gridLayout.numColumns = 1;
	    		    compoHelp.setLayout(gridLayout);

	    		    Label label1 = new Label(compoHelp, SWT.SHADOW_NONE);
	    		    org.eclipse.swt.graphics.Font label_font = new org.eclipse.swt.graphics.Font(display, new FontData("Courier", 10, SWT.BOLD));
	    		    label1.setFont(label_font);
	    		    label1.setText("Application Profile Editor v1.0");
	    		    Label label2 = new Label(compoHelp, SWT.SHADOW_NONE); 
	    		    label2.setFont(label_font);
	    		    label2.setText("Provided by the IPAC Consortium");
	    		    Text text = new Text(compoHelp, SWT.BORDER);
	    		    text.setText("Please fill the tables and then click on the Generate Profile button.");
	    		    text.setTextLimit(50);
	    		    text.setEditable(false);
	    			helpShell.open();
	    		}
	    	}
	    });
	    
		final Menu subMenu = new Menu(menu);
		openItem.setMenu(subMenu);
		//the open submenu
	    subMenu.addMenuListener(new MenuListener() {
	    	public void menuShown (MenuEvent e) {
	    		IWorkspace workspace = ResourcesPlugin.getWorkspace();
				final IWorkspaceRoot root = workspace.getRoot();
	    		//final File dir = new File(IPAC_PATH + APP_PROFILE_EDITOR_PATH);
				///test test test test test
				final File dir = new File(root.getLocation().toString());
				//////////////////////////////////////
	    		String[] children = dir.list();
	    	    if (children == null) {
	    	    } 
	    	    else {
	    	    	int count = 0;
	    	    	for (int i=0; i<children.length; i++) {
	    	    		String filename = children[i];
	    	            //if (filename.contains("Ipac_App"))
	    	    		if (filename.contains(".pl"))//(filename.contains("Profile_"))
	    	            	count++;
	    	    	}
	    	    	if (subMenu.getItems().length != count) {
	    	    		for (int i=0; i<children.length; i++) {
		    	            String filename = children[i];
		    	            //if (filename.contains("Ipac_App")) {
		    	            if (filename.contains(".pl")) {//(filename.contains("Profile_")) {
		    	            	if (!fileExistsinMenu(filename, subMenu)){
			    	            	final MenuItem mitem = new MenuItem(subMenu, SWT.PUSH);
			    	  	      		mitem.setText(filename);
			    	  	      		mitem.addSelectionListener(new SelectionListener() {
			    	  	      			public void widgetDefaultSelected(SelectionEvent event) {	
			    	  	      			}
			    	  	      			public void widgetSelected(SelectionEvent event) {
			    	  	      				appStored.setVisible(false);
			    	  	      				newApp = false;
			    	  	      				oldAppID = mitem.getText();
			    	  	      				String[] names = mitem.getText().split("_");
			    	  	      				applicationID = names[names.length-1];
			    	  	      				// Here we fill the Table with already defined data
			    	  	      				try{
			    		  	      				tableItems.clear(); 
			    			  					//BufferedReader appFile = new BufferedReader(new FileReader(IPAC_PATH + APP_PROFILE_EDITOR_PATH + mitem.getText()));
			    		  	      				//test test test test test test test
			    		  	      				BufferedReader appFile = new BufferedReader(new FileReader(root.getLocation() + "/" + mitem.getText()));
			    		  	      				//////////////////////////////////////
			    			  					String line = null;
			    			  					int countGroup = 0; int countUI = 0; 
			    			  					String itemValue = null; String itemName = null; 
			    			  					int countSensor = 0;
			    			  					eventTable.removeAll();
			    			  					ProfileItem pi;
    			  								String iname;
    			  								Vector<String> sensors = getSensors();
    			  								ArrayList<Event> eventsList = new ArrayList<Event>();
			    			  					while ((line = appFile.readLine()) != null) {
			    			  						//Line contains generic property
			    			  						if (line.contains(").")) { //(line.contains("(")) {
		    			  								itemName = line.substring(0, line.indexOf("("));
		    			  								itemValue = line.substring(line.indexOf("(")+1, line.indexOf(")"));
		    			  								
		    			  								if (itemValue.equalsIgnoreCase("none"))
		    			  									itemValue = "";
		    			  								
		    			  								if (line.contains("hasTTL")) {
		    			  									String evName = line.substring(line.indexOf("(")+1, line.indexOf(","));
		    			  									String ttl = line.substring(line.indexOf(", ")+1, line.indexOf(")"));
		    			  									int position = getEventPosition(evName, eventsList);
		    			  									if (position!=-1) {
		    			  										eventsList.get(position).setTTL(ttl);
		    			  									}
		    			  									else {
		    			  										Event ev = new Event(evName, ttl, "");
		    			  										eventsList.add(ev);
		    			  									}
		    			  								}
		    			  								else if (line.contains("hasHTL")){
		    			  									String evName = line.substring(line.indexOf("(")+1, line.indexOf(","));
		    			  									String htl = line.substring(line.indexOf(", ")+1, line.indexOf(")"));
		    			  									int position = getEventPosition(evName, eventsList);
		    			  									if (position!=-1) {
		    			  										eventsList.get(position).setHTL(htl);
		    			  									}
		    			  									else {
		    			  										Event ev = new Event(evName, "", htl);
		    			  										eventsList.add(ev);
		    			  									}
		    			  								}
		    			  								//if there are two or more supportsGroup definitions
		    			  								if (line.contains("supportsGroup")){
			    			  								countGroup++;
			    			  								iname = itemName+"_"+countGroup;
			    			  								pi = new ProfileItem(iname, itemValue, "");
			    			  							}
			    			  							//if there are two or more requiresUI definitions
			    			  							else if (line.contains("requiresUI")) {
			    			  								countUI++;
			    			  								iname = itemName+"_"+countUI;
			    			  								pi = new ProfileItem(iname, itemValue, "");
			    			  							}
			    			  							else if (sensors.contains(itemName)) {  //(line.contains("usesSensor")) {
			    			  								countSensor++;
			    			  								iname = "usesSensor_"+countSensor;
			    			  								pi = new ProfileItem(iname, itemName, itemValue);  //new ProfileItem(iname, itemValue, sensorID);
			    			  							}
			    			  							else {
			    			  								pi = new ProfileItem(itemName, itemValue, "");
			    			  							}	
			    			  							tableItems.add(pi);
			    			  						}
			    			  						//Events now. may be in a separate while!!
			    			  						else if (line.contains(":-")) {
			    			  							String eventName = null;
			    			  							StringTokenizer conditions; 
			    			  							String lPart = line.substring(0, line.indexOf(":-")-1);
			    			  							eventName = lPart.substring(lPart.indexOf("(")+1, lPart.indexOf(")"));
			    			  							//if the event is not on the list add it and 
			    			  							
			    			  							int position = getEventPosition(eventName, eventsList);
	    			  									if (position==-1) {
	    			  										Event ev = new Event(eventName, "", "");
	    			  										eventsList.add(ev);
	    			  									}
    			  										
			    			  							conditions = new StringTokenizer(line.substring(line.indexOf(":-")+2, line.indexOf(".")));
			    			  							//Add a new Event in the Table
			    			  							TableItem item = new TableItem(eventTable, SWT.NONE);
			    			  							//get TTL and HTL from the Events Vector
			    			  							String ttl = eventsList.get(getEventPosition(eventName, eventsList)).getTTL();
			    			  							String htl = eventsList.get(getEventPosition(eventName, eventsList)).getHTL();
			    			  							//System.out.println("Position="+position+"ttl="+ttl+" htl="+htl);
			    			  							//Insert the new Line in the Table
			    			  							item.setText(new String[] { eventName, ttl, htl, "" } );
			    			  							//item.setText(new String[] { eventName, "", "", "" } );
			    			  							item.setBackground(0, eventNameColor);
			    			  							item.setFont(eventFont);
			    			  							String cond = null; String operator = null;
			    			  							String leftPart = null; String rightPart = null;
			    			  							StringTokenizer str = null; String currentCondition = null;
			    			  							while (conditions.hasMoreTokens()) {
			    			  								//Split the line and add the condition into the Table
			    			  								currentCondition = conditions.nextToken();
			    			  								if (currentCondition.contains(","))
			    			  									cond = currentCondition.replaceAll(",", "");
			    			  								else
			    			  									cond = currentCondition;
			    			  			        			if (cond.contains(">=")) {
			    			  			        				operator = ">=";
			    			  			        				str = new StringTokenizer(cond.replace(">=", " "));
			    			  			        			}
			    			  			        			else if (cond.contains("<=")) {
			    			  			        				operator = "<=";
			    			  			        				str = new StringTokenizer(cond.replace("<=", " "));
			    			  			        			}
			    			  			        			else if (cond.contains("<")) {
			    			  			        				operator = "<";
			    			  			        				str = new StringTokenizer(cond.replace("<", " "));
			    			  			        			}	
			    			  			        			else if (cond.contains(">")) {
			    			  			        				operator = ">";
			    			  			        				str = new StringTokenizer(cond.replace(">", " "));
			    			  			        			}
			    			  			        			else if (cond.contains("==")) {
			    			  			        				operator = "==";
			    			  			        				str = new StringTokenizer(cond.replace("==", " "));
			    			  			        			}
			    			  			        			else if (cond.contains("!=")) {
			    			  			        				operator = "!=";
			    			  			        				str = new StringTokenizer(cond.replace("!=", " "));
			    			  			        			}
			    			  			        			leftPart = str.nextToken(); //cond.substring(0, opIndex);
			    			  			        			rightPart = str.nextToken(); //cond.substring(opIndex+3);
			    			  								TableItem itemInserted = new TableItem(eventTable, SWT.NONE); //, index+1);
			    			  								itemInserted.setText(new String[] { "Condition", leftPart, operator, rightPart } );
			    			  								itemInserted.setBackground(0, conditionColor);
			    			  							}
			    			  						}
			    			  					  }//while
			    			  					
			    			  					genTable.removeAll();
			    			  					TableItem item;
			    			  					for (int i=0; i<genAttributes.length; i++)
			    			  					{
			    			  						if (genAttributes[i].equalsIgnoreCase("supportsGroup") && countGroup != 0){
			    			  							for (int k=1; k<=countGroup; k++){
			    			  								item = new TableItem(genTable, SWT.NONE);
			    			  								String iName = "supportsGroup_"+k;
			    			  								item.setText(new String[] { genAttributes[i], findItemValue(iName, tableItems), "" } );
					    			  						item.setBackground(0, labelColor);
			    			  							}
		    			  							}
		    			  							//if there are two or more requiresUI definitions
		    			  							else if (genAttributes[i].equalsIgnoreCase("requiresUI") && countUI != 0) {
		    			  								for (int k=1; k<=countUI; k++){
			    			  								item = new TableItem(genTable, SWT.NONE);
			    			  								String iName = "requiresUI_"+k;
			    			  								item.setText(new String[] { genAttributes[i], findItemValue(iName, tableItems), "" } );
					    			  						item.setBackground(0, labelColor);
			    			  							}
		    			  							}
		    			  							else if (genAttributes[i].equalsIgnoreCase("usesSensor") && countSensor != 0) {
		    			  								for (int k=1; k<=countSensor; k++){
			    			  								item = new TableItem(genTable, SWT.NONE);
			    			  								String iName = "usesSensor_"+k;
			    			  								item.setText(new String[] { genAttributes[i], findItemValue(iName, tableItems), findSensorID(iName, tableItems) } );
					    			  						item.setBackground(0, labelColor);
			    			  							}
		    			  							}
		    			  							else {
		    			  								item = new TableItem(genTable, SWT.NONE);
		    			  								item.setText(new String[] { genAttributes[i], findItemValue(genAttributes[i], tableItems), "" } );
				    			  						item.setBackground(0, labelColor);
		    			  							}
			    			  					}
			    			  					//Define the editor for the first table (generic information)
			    			  					final TableEditor editor = new TableEditor(genTable);
			    			  					genTable.addMouseListener(new MouseAdapter() {
			    			  						public void mouseDown(MouseEvent event) {
			    			  							Control old = editor.getEditor();
			    			  							if (old != null) old.dispose();
			    			  							Point pt = new Point(event.x, event.y);
			    			  							final TableItem item = genTable.getItem(pt);
			    			  							if (item != null && !item.getText().equalsIgnoreCase("ID")) {
			    			  								if (item.getText().equalsIgnoreCase("Criticality")
			    			  									|| item.getText().equalsIgnoreCase("requiresUI")
			    			  									|| item.getText().equalsIgnoreCase("usesSensor")) {
			    			  									int column = -1;
			    			  						        	for (int i = 0, n = genTable.getColumnCount(); i < n; i++) {
			    			  						        		Rectangle rect = item.getBounds(i);
			    			  						        		if (rect.contains(pt)) {
			    			  						        				column = i;
			    			  						        				break;
			    			  						        		}
			    			  						        	}
			    			  						        	if (column == 1) {
			    			  						        		final Combo combo = new Combo(genTable, SWT.READ_ONLY);
			    			  						        		if (item.getText().equalsIgnoreCase("Criticality")) {
			    			  						        			for (int i = 0, n = criticalityAtts.length; i < n; i++) {
			    			  							        			combo.add(criticalityAtts[i]);
			    			  							        		}
			    			  						        		}
			    			  						        		else if (item.getText().equalsIgnoreCase("requiresUI")) {
			    			  						        			for (int i = 0, n = UIAtts.length; i < n; i++) {
			    			  							        			combo.add(UIAtts[i]);
			    			  							        		}
			    			  						        		}
			    			  						        		else if (item.getText().equalsIgnoreCase("usesSensor")) {
			    			  						        			for (int i = 0, n = sensorAtts.size(); i < n; i++) {
			    			  							        			combo.add((String)sensorAtts.get(i));
			    			  							        		}
			    			  						        		}
			    			  						        		combo.select(combo.indexOf(item.getText(column)));
			    			  						        		editor.minimumWidth = 310;
			    			  						        		genTable.getColumn(column).setWidth(editor.minimumWidth);
			    			  						        		combo.setFocus();
			    			  						        		editor.setEditor(combo, item, column);
			    			  						        		final int col = column;
			    			  						        		combo.addSelectionListener(new SelectionAdapter() {
			    			  						        			public void widgetSelected(SelectionEvent event) {
			    			  						        				item.setText(col, combo.getText());
			    			  						        				combo.dispose();
			    			  						        			}
			    			  						        		});
			    			  						        	}
			    			  						        	else {
			    			  						        		if (item.getText().equalsIgnoreCase("usesSensor")) {
			    			  								        	//Text Editor for the Sensor ID in the Second Column
			    			  								        	Text new2Editor = new Text(genTable, SWT.NONE);
			    			  								        	new2Editor.setText(item.getText(2));
			    			  								        	new2Editor.addModifyListener(new ModifyListener() {
			    			  								        		public void modifyText(ModifyEvent me) {
			    			  								        			Text text = (Text) editor.getEditor();
			    			  								        			editor.getItem().setText(2, text.getText());
			    			  								        		}
			    			  								        	});
			    			  								        	new2Editor.selectAll();
			    			  								        	new2Editor.setFocus();
			    			  								        	editor.setEditor(new2Editor, item, 2);
			    			  						        		}			        		
			    			  						        	}
			    			  				        		}
			    			  								else {
			    			  									//Text Editor for the rest parameters
			    			  									Text newEditor = new Text(genTable, SWT.NONE);
			    			  							        newEditor.setText(item.getText(1));
			    			  							        newEditor.addModifyListener(new ModifyListener() {
			    			  							        	public void modifyText(ModifyEvent me) {
			    			  							        		Text text = (Text) editor.getEditor();
			    			  							        		editor.getItem().setText(1, text.getText());
			    			  							        	}
			    			  							        });
			    			  							        newEditor.selectAll();
			    			  							        newEditor.setFocus();
			    			  							        editor.setEditor(newEditor, item, 1);
			    			  								}
			    			  							}//if item!=null	
			    			  						} //mouseDown
			    			  				    });
			    			  					appFile.close();
			    	  	      				}//try
			    	  	      				catch (IOException e) {
			    	  	      					System.out.println("Problem with the file!");
			    	  	      				}
			    	  	      			}
			    	  	      		});
			    	            }
			    			            
		    	            }
		    	            
		    	        }//for
	    	    	}//if
	    	        
	    	    }//else
	    	}
	    	public void menuHidden (MenuEvent e) {
	    	}
	    });

	  //Generate the application profile
		Button generateProfile = new Button( buttons_composite, SWT.PUSH | SWT.CENTER  );
		generateProfile.setText("Generate Profile");
		generateProfile.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				try {
					//if (newApp) {
					//	BufferedWriter writeID = new BufferedWriter(new FileWriter(IPAC_PATH + APP_PROFILE_EDITOR_PATH + IDS_FILE));
				    //    idNumber++;
				    //    writeID.write(idNumber.toString());
				    //    writeID.close();
					//}
					TableItem item;
			        TableItem[] items = genTable.getItems();
			        Vector<String> sensors = new Vector<String>();
			        ////test test test test 
			        //System.out.println("I enter!!!");
			        IWorkspace workspace = ResourcesPlugin.getWorkspace();
					IWorkspaceRoot root = workspace.getRoot();
					///System.out.println("root="+root.getLocation());
					////////////////////////////////////
			        BufferedWriter appFile; 
			        if (newApp) {
			        	appFileName = items[1].getText(1) + "_" + applicationID;//"Profile_" + items[1].getText(1) + "_" + applicationID;
			        	//appFile = new BufferedWriter(new FileWriter(IPAC_PATH + APP_PROFILE_EDITOR_PATH + appFileName + APP_PROFILE_FILE_EXTENSION));
			        	///test test test test
			        	appFile = new BufferedWriter(new FileWriter(root.getLocation()+"/" + appFileName + APP_PROFILE_FILE_EXTENSION));
			        	///////////////////////
			        	//applicationID = id;
			        }	
			        else {
			        	
			        	//appFile = new BufferedWriter(new FileWriter(IPAC_PATH + APP_PROFILE_EDITOR_PATH + oldAppID));
			        	//test test test test
			        	appFile = new BufferedWriter(new FileWriter(root.getLocation() +"/" + oldAppID));
			        	/////////////////////////////////////////////////////////
			        	//applicationID = oldAppID;
			        }
			        //System.out.println("I passed!!!!");
			        
			        for (int i=0; i<items.length; i++) {
			        	item = items[i];
			        	//if there is text in the item
			        	if (item.getText(1).trim().length() != 0)
			        	{
			        		if (item.getText(0).equalsIgnoreCase("usesSensor")) {
				        		if (!sensors.contains(item.getText(1))) {
				        			appFile.write(item.getText(0)+"("+item.getText(1)+").");
				        			appFile.newLine();
				        			sensors.add(item.getText(1));
				        		}
				        		//Produce the appropriate lines for Sensors
				        		if (item.getText(0).equalsIgnoreCase("usesSensor")
				        			&& item.getText(2).trim().length() !=0 ) {
				        			appFile.write(item.getText(1)+"("+item.getText(2)+").");
				        			appFile.newLine();
				        		}
				        		
				        	}
				        	else {
				        		appFile.write(item.getText(0)+"("+item.getText(1)+").");
			        			appFile.newLine();
				        	}
			        	}
			        	//if it contains "requires" and it is empty, fill with "none"
			        	else {
			        		if (item.getText(0).toLowerCase().contains("requires")) {
			        			appFile.write(item.getText(0)+"(none).");
			        			appFile.newLine();
			        		}
			        	}
			        }
			        sensors.clear();
			        items = eventTable.getItems();
			        int i = 0; 
			        String line;
			        
			        while (i < items.length) {
			        	item = items[i];
		        		if (!item.getText(0).equalsIgnoreCase("Condition")) {
		        			if (item.getText(1).trim().length() !=0 && item.getText(2).trim().length() !=0
		        				&& i<items.length-1 && items[i+1].getText(0).equalsIgnoreCase("condition")
		        				&& items[i+1].getText(1).trim().length() !=0 && items[i+1].getText(2).trim().length() !=0
		        				&& items[i+1].getText(3).trim().length() !=0) {
		        				appFile.write("hasTTL("+item.getText(0)+", "+item.getText(1)+").");
				        		appFile.newLine();
				        		appFile.write("hasHTL("+item.getText(0)+", "+item.getText(2)+").");
				        		appFile.newLine();
				        		appFile.write("event("+item.getText(0)+") :- ");
		        			}
		        			else if ((item.getText(1).trim().length()==0 || item.getText(2).trim().length()==0)
			        				&& i<items.length-1 && items[i+1].getText(0).equalsIgnoreCase("Condition")
			        				&& items[i+1].getText(1).trim().length() !=0 && items[i+1].getText(2).trim().length() !=0
			        				&& items[i+1].getText(3).trim().length() !=0) 
					        			appFile.write("event("+item.getText(0)+") :- ");
			        		i ++;
			        	}
			        	else {
			        		line = "";
			        		boolean someone = false;
			        		while (i < items.length && item.getText(0).equalsIgnoreCase("Condition")) {
			        			if (item.getText(1).trim().length() !=0 &&
			        				item.getText(2).trim().length() !=0 &&
			        				item.getText(3).trim().length() !=0 ) {
			        				someone = true;
			        				line += (item.getText(1)+item.getText(2)+item.getText(3)+" ,");
			        			}
			        			i ++;
			        			if (i<items.length) {
			        				item = items[i];
			        			}
			        		}
			        		line = line.substring(0, line.lastIndexOf(",")-1);
			        		line += ".";
			        		if (someone) {
			        			appFile.write(line);
			        			appFile.newLine();
			        		}
			        	}
			        }
			        appFile.close();
			        //shell.close();
			        appStored.setVisible(true);
			        
				}
				catch (Exception ex)
				{ System.out.println("Error in profile generation!"); }
			}
		});
		shell.setMenuBar(menu);
	    shell.open();
	}
	
	/*private void initializeJIProlog() {
		//JIPEngine engine = null;
    	//JIPTermParser termParser = null;
        try
        { 
        	//engine = new JIPEngine();
    		//termParser = engine.getTermParser();
    		File profileFile = new File(IPAC_PATH + APP_PROFILE_EDITOR_PATH + SENSOR_MODEL_FILE);
    		
    		FileInputStream profileFis = null;
    		try {
    			profileFis = new FileInputStream(profileFile);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profileFis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
        }
        finally { }
	}*/
	
	
	public ArrayList<String> getSensorTypes() {	
		ArrayList<String> sensors = new ArrayList<String>();
		/*ArrayList<String> properties = new ArrayList<String>();
		try {
			File f=new File(IPAC_PATH + APP_PROFILE_EDITOR_PATH + SENSOR_MODEL_FILE);
	    	FileInputStream is=new FileInputStream(f);
	    	OWLModel model=ProtegeOWL.createJenaOWLModelFromInputStream(is);
	    	OWLNamedClass sensorType=model.getOWLNamedClass("Sensor_Type");
	    	Iterator col = sensorType.getInstances().iterator();
	    	OWLIndividual name;
	    	while (col.hasNext() ) {
	    		name = (OWLIndividual) col.next();
	    		sensors.add(name.getLocalName());
	    	}
	    	is.close();
		} catch (Exception ex) { 
				System.out.println("Error reading sensor ontology!");   
			}
	    */
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profileFile = new File(IPAC_PATH + APP_PROFILE_EDITOR_PATH + SENSOR_MODEL_FILE);
    		
    		FileInputStream profileFis = null;
    		try {
    			profileFis = new FileInputStream(profileFile);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profileFis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-sensorType(X).");
			JIPTerm solution;
			while ((solution = query_results.nextSolution()) != null) {
				String sensor = solution.toString();
				String sensorType = sensor.substring(sensor.indexOf("(")+1, sensor.indexOf(")"));
				sensors.add(sensorType);
			}
        }
        finally { }
		
		return sensors;
	}
	
	public Vector<String> getSensors() {	
		Vector<String> sensors = new Vector<String>();
		/*try {
			File f=new File(IPAC_PATH + APP_PROFILE_EDITOR_PATH + SENSOR_MODEL_FILE);
	    	FileInputStream is=new FileInputStream(f);
	    	OWLModel model=ProtegeOWL.createJenaOWLModelFromInputStream(is);
	    	OWLNamedClass sensorType=model.getOWLNamedClass("Sensor_Type");
	    	Iterator col = sensorType.getInstances().iterator();
	    	OWLIndividual name;
	    	while (col.hasNext() ) {
	    		name = (OWLIndividual) col.next();
	    		sensors.add(name.getLocalName());
	    	}
	    	is.close();
		} catch (Exception ex) { 
				System.out.println("Error reading sensor ontology!");   
			}*/
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profileFile = new File(IPAC_PATH + APP_PROFILE_EDITOR_PATH + SENSOR_MODEL_FILE);
    		FileInputStream profileFis = null;
    		try {
    			profileFis = new FileInputStream(profileFile);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profileFis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-sensorType(X).");
			JIPTerm solution;
			while ((solution = query_results.nextSolution()) != null) {
				String sensor = solution.toString();
				String sensorType = sensor.substring(sensor.indexOf("(")+1, sensor.indexOf(")"));
				sensors.add(sensorType);
			}
        }
        finally { }
	    
		return sensors;
	}
	
/*	public ArrayList<String> getProperties() {
		ArrayList<String> sensors = new ArrayList<String>();
		ArrayList<String> properties = new ArrayList<String>();
		try {
				File f=new File(IPAC_PATH + APP_PROFILE_EDITOR_PATH + SENSOR_MODEL_FILE);
				FileInputStream is=new FileInputStream(f);
				OWLModel model=ProtegeOWL.createJenaOWLModelFromInputStream(is);
		    	Iterator props = model.getUserDefinedOWLObjectProperties().iterator(); //.listRDFProperties();;
		    	OWLObjectProperty oProp;
		    	while (props.hasNext() ) {
		    		oProp = (OWLObjectProperty) props.next();
		    		properties.add(oProp.getLocalName());
		    	}
		    	props = model.getUserDefinedOWLDatatypeProperties().iterator();
		    	OWLDatatypeProperty dProp;
		    	while (props.hasNext() ) {
		    		dProp = (OWLDatatypeProperty) props.next();
		    		properties.add(dProp.getLocalName());
		    	}
		    	is.close();
			} catch (Exception e) { 
					System.out.println("Oupssssssssss"); 
				}
			
			return properties;
		}
	*/
	public String findItemValue(String name, ArrayList<ProfileItem> tableItems) {
		if (tableItems.size() != 0) {
			for (int i = 0; i < tableItems.size(); i++) {
				ProfileItem pi = (ProfileItem)tableItems.get(i);
				if (pi.getItemName().equalsIgnoreCase(name))
					return pi.getItemValue();
			}
		}
		return "";
	}
	
	public String findSensorID(String name, ArrayList<ProfileItem> tableItems) {
		if (tableItems.size() != 0) {
			for (int i = 0; i < tableItems.size(); i++) {
				ProfileItem pi = (ProfileItem)tableItems.get(i);
				if (pi.getItemName().equalsIgnoreCase(name))
					return pi.getSensorName();
			}
		}
		return "";
	}
	
	public int getEventPosition(String eventName, ArrayList<Event> events) {
		int position = -1;
		for (int i =0; i< events.size(); i++)
			if (events.get(i).getEventName().equalsIgnoreCase(eventName))
				return i;
		return position;
	}
	
	public boolean fileExistsinMenu (String filename, Menu subMenu) {
		for (int i = 0; i < subMenu.getItems().length; i ++) {
			if (subMenu.getItem(i).getText().equalsIgnoreCase(filename))
				return true;
		}
		return false;
	}
	
	private static String produceID (String s) {
		//return String.valueOf(Math.abs(s.hashCode()));
		return AppIDUtils.createAppID(s);
	}
}