package eu.ipac.ace.adl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.String;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openarchitectureware.xtext.parser.model.NodeUtil;

import com.ugos.JIProlog.engine.JIPEngine;
import com.ugos.JIProlog.engine.JIPQuery;
import com.ugos.JIProlog.engine.JIPTerm;
import com.ugos.JIProlog.engine.JIPTermParser;

/**
 * General methods used by editors extensions
 * 
 * @version 	1.0 19 Mar 2009
 * @author 	K.Kolomvatsos
 */

public class Utilities {

	private static final String IPAC_PATH = "C://IPAC_ROOT//";;
	private static final String FILES_PATH="Models//";
	private static final String SERVICE_MODEL_FILE = "profile_service.pl";
	private static final String APP_PROFILE_EDITOR_PATH = "//IPAC_Files//"; 
	
	private static final String APPNAMES_IDS_SEPERATOR = "<->";
	
	/**
	 * Checks if the specified string is a reserved word.
	 * @param str
	 * @return
	 */
	//done
	public static boolean isReserved(String name) {
		if (name.equalsIgnoreCase("String") || name.equalsIgnoreCase("int") || name.equalsIgnoreCase("boolean") ||
				name.equalsIgnoreCase("double") || name.equalsIgnoreCase("invoke") || name.equalsIgnoreCase("if") ||
				name.equalsIgnoreCase("else") || name.equalsIgnoreCase("switch") || name.equalsIgnoreCase("var") ||
				name.equalsIgnoreCase("default") || name.equalsIgnoreCase("const") || name.equalsIgnoreCase("method") ||
				name.equalsIgnoreCase("wait") || name.equalsIgnoreCase("onFault") || name.equalsIgnoreCase("while") ||
				name.equalsIgnoreCase("input") || name.equalsIgnoreCase("output") ) {
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * Checks if the specified string starts with a digit.
	 * @param str
	 * @return
	 */
	//done
	public static boolean startsWithDigit(String name) {
		if (name.startsWith("0") || name.startsWith("1") || name.startsWith("2") || 
				name.startsWith("3") || name.startsWith("4") || name.startsWith("5") || 
				name.startsWith("6") || name.startsWith("7") || name.startsWith("8") || name.startsWith("9")) {
			return true;
		}
		else {
			return false;
		}

	}

	/**
	 * Checks if the specified serviceName is valid.
	 * @param serviceName
	 * @return 
	 */
	//done
	public static boolean isValidService(String serviceName) {
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		} 
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-service(X).");
			JIPTerm solution;
				while ((solution = query_results.nextSolution()) != null) {
					String srv = solution.toString();
					String service = srv.substring(srv.indexOf("(")+1, srv.indexOf(")"));
					if (service.equalsIgnoreCase(serviceName))
						return true;
				}
        }
        catch (Exception e) { 
        	return false;
        }
        
		return false;

	}

	/**
	 * Checks if the specified method belongs to the specified service.
	 * @param serviceName
	 * @param methodName
	 * @return
	 */
	//done
	public static boolean isValidMethod(String serviceName, String methodName) {
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-hasMethod(X, Y).");
			JIPTerm solution;
			while ((solution = query_results.nextSolution()) != null) {
				String srv = solution.toString();
				String srvName = srv.substring(srv.indexOf("(")+1, srv.indexOf(", ")).trim();
				String mtdName = srv.substring(srv.indexOf(", ")+1, srv.indexOf(")")).trim();
				if (srvName.equalsIgnoreCase(serviceName) && mtdName.equalsIgnoreCase(methodName))
					return true;
			}
        }
        catch (Exception e) { 
        	return false;
        }
		
		return false;
	}
	//done
	public static String getMethodReturnedType (String serviceName, String methodName) {
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-hasMethod("+serviceName+", "+methodName+").");
			JIPTerm solution;
			if ((solution = query_results.nextSolution()) != null) {
				JIPQuery secondQuery = engine.openSynchronousQuery("?-hasReturnType("+methodName+", Y).");
				JIPTerm secondSolution;
				if ((secondSolution = secondQuery.nextSolution()) != null) {
					String srv = secondSolution.toString();
					String typeName = srv.substring(srv.indexOf(", ")+1, srv.indexOf(")")).trim();
					//System.out.println(typeName);
					return typeName;
				}
			}
			return null;
        }
        catch (Exception e) { 
        	return null;
        }
		
	}
	//done
	public static int getMethodParamNum(String serviceName, String methodName) {
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-hasMethod("+serviceName+", "+methodName+").");
			JIPTerm solution;
			if ((solution = query_results.nextSolution()) != null) {
				JIPQuery secondQuery = engine.openSynchronousQuery("?-numberOfParameters("+methodName+", Y).");
				JIPTerm secondSolution;
				if ((secondSolution = secondQuery.nextSolution()) != null) {
					String srv = secondSolution.toString();
					int paramNum = Integer.parseInt(srv.substring(srv.indexOf(", ")+1, srv.indexOf(")")).trim());
					return paramNum;
				}
			}
			return -1;
        }
        catch (Exception e) { 
        	return -1;
        }
	}


	/**
	 * 
	 * @return
	 */
	//done
	public static ArrayList<Object> getServices() {
		ArrayList<Object> allServices = new ArrayList<Object>();
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-service(X).");
			JIPTerm solution;
			while ((solution = query_results.nextSolution()) != null) {
				String service = solution.toString();
				String srvName = service.substring(service.indexOf("(")+1, service.indexOf(")")).trim();
				if (!allServices.contains(srvName)) {
					allServices.add(srvName);
				}
			}
			return allServices;
        }
        catch (Exception e) { 
        	return allServices;
        }
	}
	//done
	public static ArrayList<Object> getServiceMethods (String serviceName) {
		System.out.println("service---->"+serviceName);
		ArrayList<Object> methods = new ArrayList<Object>();
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-hasMethod("+serviceName+", Y).");
			JIPTerm solution;
			while ((solution = query_results.nextSolution()) != null) {
				String service = solution.toString();
				String methodName = service.substring(service.indexOf(", ")+1, service.indexOf(")")).trim();
				if (!methods.contains(methodName)) {
					String parameters = getParameters(serviceName, methodName);
					System.out.println("method====>"+methodName);
					methods.add(methodName+" ("+parameters+")");
				}
			}
			return methods;
        }
        catch (Exception e) { 
        	return methods;
        }
	}
	//done
	public static String getParameterTypeByPosition(String serviceName, String methodName, String pPosition) {
		//System.out.println("Mtd<getPrameterTypeByPostion: Service="+serviceName+" method="+methodName+" position="+pPosition);
		String returnedtype = null;
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
    	int paramPosition = Integer.parseInt(pPosition);
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-hasMethod("+serviceName+", "+methodName+").");
			JIPTerm solution;
			if ((solution = query_results.nextSolution()) != null) {
				JIPQuery secondQuery = engine.openSynchronousQuery("?-numberOfParameters("+methodName+", Y).");
				JIPTerm secondSolution;
				if ((secondSolution = secondQuery.nextSolution()) != null) {
					String ss = secondSolution.toString();
					if (paramPosition <= Integer.parseInt(ss.substring(ss.indexOf(",")+2, ss.indexOf(")")))){
						JIPQuery thirdQuery = engine.openSynchronousQuery("?-hasParameter("+methodName+", Y, "+paramPosition+").");
						JIPTerm thirdSolution;
						if ((thirdSolution = thirdQuery.nextSolution()) != null) {
							String param = thirdSolution.toString();
							//System.out.println("Mtd<getPrameterTypeByPostion: param="+param);
							//String paramName = param.substring(param.indexOf(",")+2, param.indexOf(")"));
							String paramName = param.split(",")[1];
							JIPQuery fourthQuery = engine.openSynchronousQuery("?-hasType("+paramName+", Y).");
							JIPTerm fourthSolution;
							if ((fourthSolution = fourthQuery.nextSolution()) != null) {
								String hasType = fourthSolution.toString();
								String paramType = hasType.substring(hasType.indexOf(",")+2, hasType.indexOf(")"));
								//System.out.println("ParamType===="+paramType);
								return paramType;
							}
						}
					}
				}
				
			}
        }
        catch (Exception e) { 
        	return returnedtype;
        }
        return returnedtype;
	}
	
	//done
	public static boolean checkExpression (String varType, EObject o) {
		ArrayList<String> dataTypes = new ArrayList<String>();
		o.eResource().getURI();
		TreeIterator el = NodeUtil.getNode(o).getModelElement().eAllContents();
		int exprSize = 0;
		boolean containsVector=false;
		while (el.hasNext()) {
			EObject eo = (EObject)el.next();
			String type = eo.toString();
			if (type.contains("PrimitiveElement")) {
				exprSize++;
				eo.eResource().getURI();
				TreeIterator tr = NodeUtil.getNode(eo).getModelElement().eAllContents();
				int trSize = 0;
				while (tr.hasNext()) {
					EObject eoo = (EObject)tr.next();
					//System.out.println("Some="+eoo.toString());
					String k = eoo.toString();
					String kk = k.substring(k.indexOf("impl.")+5, k.indexOf("Literal"));
					dataTypes.add(kk);
					trSize++;
				}
				List li = NodeUtil.getNode(eo).getModelElement().eCrossReferences();
				int liSize = li.size();
				for (int i=0; i<li.size(); i++) {
					EObject oeo = (EObject) li.get(i);
					////------------------------------------
					//System.out.println("AAAA="+oeo.toString());
					////////ayta pithanwn den xreiazontai me to gmf
					TreeIterator lst = oeo.eAllContents();
					String sds;
					String sdss;
					String sd;
					while (lst.hasNext()) {
						sd = lst.next().toString();
						if (sd.contains("Literal")) {
							sds = sd.split("name:")[1];
							sdss = sds.split("Literal")[0].trim();
							//System.out.println(sdss);
							dataTypes.add(sdss);	
						}
						
						
					}
					////////////////////////////////////////////////
					List ls = oeo.eClass().getEAllAttributes();
					for (int l=0; l<ls.size(); l++) {
						EAttribute ea = (EAttribute) ls.get(l);
						//System.out.println("AAAB="+ea.toString());
					}
					////-------------------------------------
					//System.out.println("Tree Size=");
					if (oeo.toString().toLowerCase().contains("vector"))// && //return false if vector is used in expression
						//liSize!=1 && trSize>0)
						containsVector=true;
					///////ayta mpainoyn sto gmf /////////////////
					//String t = oeo.toString();
					//String tt = t.substring(t.indexOf("type: ")+6, t.indexOf(","));
					//System.out.println("tt====>"+tt);
					//dataTypes.add(tt);
					/////////////////////////////////
				}
			}
		}
		
		if (exprSize>1 && containsVector)
			return false;
		
		String dt = null;
		for (int j=0; j<dataTypes.size(); j++) {
			dt = dataTypes.get(j);
			//System.out.println("--->"+dt);
			if (! dt.toLowerCase().contains(varType.toLowerCase()))
					return false;
		}
		
		return true;
	}
	//done
	public static String errorInExpression (String varType, EObject o) {
		ArrayList<String> dataTypes = new ArrayList<String>();
		o.eResource().getURI();
		TreeIterator el = NodeUtil.getNode(o).getModelElement().eAllContents();
		int exprSize=0; 
		boolean containsVector=false;
		while (el.hasNext()) {
			EObject eo = (EObject)el.next();
			String type = eo.toString();
			if (type.contains("PrimitiveElement")) {
				exprSize++;
				eo.eResource().getURI();
				TreeIterator tr = NodeUtil.getNode(eo).getModelElement().eAllContents();
				while (tr.hasNext()) {
					EObject eoo = (EObject)tr.next();
					String k = eoo.toString();
					String kk = k.substring(k.indexOf("impl.")+5, k.indexOf("Literal"));
					dataTypes.add(kk);
				}
				List li = NodeUtil.getNode(eo).getModelElement().eCrossReferences();
				for (int i=0; i<li.size(); i++) {
					EObject oeo = (EObject) li.get(i);
					if (oeo.toString().toLowerCase().contains("vector"))
						containsVector=true;
					String t = oeo.toString();
					String tt = t.substring(t.indexOf("type: ")+6, t.indexOf(","));
					dataTypes.add(tt);
				}
			}
		}
		
		if (containsVector && exprSize>1)
			return "You cannot use a Vector in expression!";
		
		String dt = null;
		for (int j=0; j<dataTypes.size(); j++) {
			dt = dataTypes.get(j);
			if (! dt.toLowerCase().contains(varType.toLowerCase()))
					return "Error in the assignment statement. Please check constants/variables datatypes!";
		}
		
		return "";
	}
	
	//done 
	public static boolean checkMethodParameters (String serviceName, String methodName, List elements) {
		//System.out.println("size="+elements.size());
		ArrayList<String> pars = new ArrayList<String>();
		for (int i=0; i<elements.size(); i++) {
			EObject eo = (EObject)elements.get(i);
			//System.out.println("I="+i);
			eo.eResource().getURI();
			TreeIterator ti = NodeUtil.getNode(eo).eAllContents();
			while (ti.hasNext()) {
				EObject oeo = (EObject) ti.next();
				///System.out.println("111="+oeo.toString());
				String line = oeo.toString();
				if (line.contains("=\'")) {
					String par = line.substring(line.indexOf("=\'")+2, line.indexOf("\',"));
					//System.out.println("2="+par);
					pars.add(par);
				}
			}
		}
		//Now check if the parameters data type are the same as in the prolog file
		String x = null;
		String type = null;
		int number = 0;
		for (int i=0; i<pars.size(); i++) {
			x = pars.get(i);
			if (x.contains("\""))
				type = "string";
			else if (x.contains("."))
				type = "double";
			else if (x.equalsIgnoreCase("true") || x.equalsIgnoreCase("false"))
				type = "boolean";
			else
				type = "integer";
			
			String position = Integer.toString(i+1);
			String parType = getParameterTypeByPosition(serviceName, methodName, position);
			//System.out.println("size="+pars.size()+" type_in_method===="+parType+"  paramType="+type);
			if (parType.contains(type))
				number++;
		}
		
		if (number==pars.size())
			return true;
		else
			return false;
	}
	
	//done
	public static String getParameters(String serviceName, String methodName) {
		//System.out.println("Service="+serviceName+" Method="+methodName);
		String returnedtype = null;
		JIPEngine engine = null;
    	JIPTermParser termParser = null;
    	
    	String parametersTypes = "";
    	
        try
        { 
        	engine = new JIPEngine();
    		termParser = engine.getTermParser();
    		File profile_file = new File(IPAC_PATH + FILES_PATH + SERVICE_MODEL_FILE);
    		FileInputStream profile_fis = null;
    		try {
    			profile_fis = new FileInputStream(profile_file);
    		} catch (Exception e) {
    			e.printStackTrace();
    		}
    		Enumeration en = engine.m_termParser.parseStream(profile_fis, "");
    		while (en.hasMoreElements()) {
    			JIPTerm nextTerm = (JIPTerm) en.nextElement();
    			engine.assertz(nextTerm);
    		}
			JIPQuery query_results = engine.openSynchronousQuery("?-hasMethod("+serviceName+", "+methodName+").");
			JIPTerm solution;
			if ((solution = query_results.nextSolution()) != null) {
				JIPQuery secondQuery = engine.openSynchronousQuery("?-numberOfParameters("+methodName+", Y).");
				JIPTerm secondSolution;
				if ((secondSolution = secondQuery.nextSolution()) != null) {
					String ss = secondSolution.toString();
					for (int i=1; i<= Integer.parseInt(ss.substring(ss.indexOf(",")+2, ss.indexOf(")"))); i++){
						//JIPQuery thirdQuery = engine.openSynchronousQuery("?-hasParameter"+i+"("+methodName+", Y).");
						JIPQuery thirdQuery = engine.openSynchronousQuery("?-hasParameter("+methodName+", Y, "+i+").");
						JIPTerm thirdSolution;
						if ((thirdSolution = thirdQuery.nextSolution()) != null) {
							
							String param = thirdSolution.toString();
							//System.out.println("third="+param);
							
							//String paramName = param.substring(param.indexOf(",")+2, param.indexOf(")"));
							//String paramName = param.substring(param.indexOf(",")+2, param.indexOf(")"));
							String paramName = param.split(", ")[1];
							JIPQuery fourthQuery = engine.openSynchronousQuery("?-hasType("+paramName+", Y).");
							JIPTerm fourthSolution;
							if ((fourthSolution = fourthQuery.nextSolution()) != null) {
								String hasType = fourthSolution.toString();
								//System.out.println("Fourth Solution==="+hasType);
								String paramType = hasType.substring(hasType.indexOf(",")+2, hasType.indexOf(")"));
								
								parametersTypes += " " + getValueType(paramType) + " _" + paramName; //" _" + getValueType(paramType);
								
							}
						}
					}
				}
				
			}
        }
        catch (Exception e) { 
        	return parametersTypes;
        }
        return parametersTypes;
	}
	
	public static String getParametersOnly(String methodString) {
		String params = "";
		String[] tokens = methodString.split(" _");
		for (int i=0; i<tokens.length; i++) {
			if (tokens[i].contains(" _")) 
				params += " " + tokens[i];
		}
		
		return params;
	}
	
	public static String getValueType(String param) {
		String dataType = param.substring(0, param.indexOf("_"));
		Character c = dataType.charAt(0);
		return dataType.replace(dataType.charAt(0), Character.toUpperCase(c));
	}
	
	//done
	public static ArrayList<Object> getApplicationIDs() {
		ArrayList<Object> ids = new ArrayList<Object>();
		File dir = new File(IPAC_PATH + FILES_PATH);
		File[] files = dir.listFiles();
		for (int i=0; i<files.length; i++) {
			if (files[i].getName().contains(".pl") && files[i].getName().contains("App"))
				ids.add(files[i].getName().substring(0, files[i].getName().indexOf(".pl")));
		}
		return ids;
	}
	
	//done
	public static ArrayList<String> getApplicationEvents(String appName) {
		//remove the ) at the last character
		//System.out.println("App Name===>"+appName);
		//////////ayto mallon den xreiazetai sto gmf///////////
		appName = appName.split(",")[0];
		//System.out.println("App Name===>"+appName);
		//////////////////////////////////////////////////////
		if (appName.contains(")"))
			appName = appName.substring(0, appName.length()-1);
		//System.out.println("========"+appName);
		//Read the events list from the Prolog file
		ArrayList<String> eventList = new ArrayList<String>();
		try {
			//System.out.println("Application file="+appName+".pl");
			//BufferedReader prolFile = new BufferedReader(new FileReader(IPAC_PATH + FILES_PATH + appName.trim()+".pl"));
			////test test test test test
			IWorkspace workspace = ResourcesPlugin.getWorkspace();
			IWorkspaceRoot root = workspace.getRoot();
			BufferedReader prolFile = new BufferedReader(new FileReader(root.getLocation()+ "/" + appName.trim()+".pl"));
			///////////////////////////////////
			String line = null;
			while ((line = prolFile.readLine()) != null) {
				//System.out.println("Line="+line);
				if (line.contains(":-")) {
					String event = line.substring(0, line.indexOf(":-")-1).trim();
					String eventName = event.substring(event.indexOf("(")+1, event.indexOf(")"));
					eventList.add(eventName);
				}
			}
			return eventList;
		}
		catch (Exception e) {
			System.out.println(e);
			return eventList;
		}
	}
	
	//done
	public static boolean checkEvent(String eventName, String appName) {
		boolean found = false;
		//System.out.println("Event="+eventName+" App="+appName);
		ArrayList<String> eventNames = getApplicationEvents(appName);
		if (eventNames.contains(eventName))
			return true;
		return found;
	}
	
	/**
	 * 
	 * @return
	 */
	public static ArrayList<String> getAppNamesAndIDs() {
		ArrayList<String> namesAndIds = new ArrayList<String>();
		final File dir = new File(IPAC_PATH + FILES_PATH);
		String[] children = dir.list();

	    if (children == null) {
	    } 
	    else {
	    	int count = 0;
	    	String name;
	    	String[] names;
	    	String id;
	    	String nameAndId;
	    	for (int i=0; i<children.length; i++) {
	    		String filename = children[i];
	    		if (filename.contains(".pl") && filename.contains("Profile") ) {
	    			names = filename.split("_");
	    			name = names[1];
	    			id = names[names.length-1].substring(0, names[names.length-1].indexOf("."));
	    			nameAndId = name + APPNAMES_IDS_SEPERATOR + id;
	    			namesAndIds.add(nameAndId);
	    		}
	    	}
	    }
		return namesAndIds;
	}
}
