package eu.ipac.ace.adl;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class EclipseUtils {
	
	private static final String APPNAMES_IDS_SEPERATOR = "<->";
	private static final String SOURCE_FOLDER = "//src"; 
	
	/**
	 * Retrieves all the projects in the current workspace  
	 * @return an array of IProject elements of the current workspace
	 */
	public static IProject[] getWorkspaceProjects() {
	
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = workspace.getRoot();
		IPath location = root.getLocation();
		//System.out.println("Workspace:" + location.toString());
		
		// Return projects.
		return root.getProjects();
	}
	
	/**
	 * Get all the available .pl files in the specified project.
	 * @param project the project to be searched for .pl files.
	 * @return a list with the fileNames of the profile files. 
	 */
	public static ArrayList<String> getProfilesFromProject(IProject project) {
		ArrayList<String> profiles = new ArrayList<String>();
		
		File projectDir = new File(project.getLocation().toString() + SOURCE_FOLDER);
		//System.out.println("Project: " + projectDir.toString());
		String[] children = projectDir.list();
		for (int i=0; i<children.length; i++) {
			String fileName = children[i];
    		if (fileName.contains(".pl") && fileName.contains("Profile") ) {
    			profiles.add(fileName);
    		}
		}
		return profiles;
	}
	
	/**
	 * Get the ApplicationName and the ApplicationID which are present in the specified project.
	 * @param project the specified project
	 * @return an arrayList with pairs like "applicationName<->applicationID"
	 */
	public static ArrayList<String> getAppNamesIDsFromProject(IProject project) {
		ArrayList<String> namesIds = new ArrayList<String>();
		
		ArrayList<String> profiles = getProfilesFromProject(project);	
		for(int j=0; j<profiles.size(); j++) {
			String p = profiles.get(j);
			String[] tokens = p.substring(0, p.indexOf(".")).split("_");
			namesIds.add(tokens[1] + APPNAMES_IDS_SEPERATOR + tokens[2]);
		}

		return namesIds;
	}
	
	/**
	 * Retrieves all the pairs (ApplicationName,ApplicationID) from the current workspace.
	 * @return a list with such pairs.
	 */
	/*public static ArrayList<String> getAppNamesIDsFromWorkspace() {
		ArrayList<String> namesIds = new ArrayList<String>();
		
		IProject[] projects = getWorkspaceProjects();
		for(int i=0; i<projects.length; i++) {
			ArrayList<String> profiles = getProfilesFromProject(projects[i]);
			
			for(int j=0; j<profiles.size(); j++) {
				String p = profiles.get(j);
				String[] tokens = p.substring(0, p.indexOf(".")).split("_");
				namesIds.add(tokens[1] + APPNAMES_IDS_SEPERATOR + tokens[2]);
			}
		}

		return namesIds;
	}*/
	///////////test test test test test test test test
	public static ArrayList<String> getAppNamesIDsFromWorkspace() {
		ArrayList<String> namesIDs = new ArrayList<String>();
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = workspace.getRoot();
		IPath location = root.getLocation();
		final File dir = new File(location.toString());
		String[] children = dir.list();
	    if (children == null) {
	    } 
	    else {
	    	for (int i=0; i<children.length; i++) {
	    		String filename = children[i];
	    		if (filename.endsWith(".pl") ) {
	    			filename = filename.substring(0, filename.indexOf("."));
	    			namesIDs.add(filename.split("_")[0] + APPNAMES_IDS_SEPERATOR + filename.split("_")[1]);
	    		}
	    	}
	    }
		
		return namesIDs;
	}
	//////////////////////////////////////////////////////////////////////////////////
	/**
	 * Proposals for the content assist mechanism.
	 * ApplicationName -> ID: ApplicationID <SEPERATOR> ApplicationName_ApplicationID
	 * @return
	 */
	public static ArrayList<String> cAssistAppNamesAndIds() {
		ArrayList<String> namesIds = new ArrayList<String>();
		ArrayList<String> temp = getAppNamesIDsFromWorkspace();
		for(int i=0; i<temp.size(); i++) {
			String[] tokens = temp.get(i).split(APPNAMES_IDS_SEPERATOR);
			namesIds.add(tokens[0] + " -> ID:" + tokens[1] + APPNAMES_IDS_SEPERATOR + 
						 tokens[0] + "_" + tokens[1]);
		}
		
		return namesIds;	
	}
	
	/**
	 * 
	 */
	public static void saveProfileToSelectedProject() {
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = workspace.getRoot();
		
		File projectDir = new File(root.getProjects()[0].getLocation().toString() + SOURCE_FOLDER +"lol");
		projectDir.mkdir();
	}
	
	

}
