package eu.ipac.ace.adl.resource;

import java.io.InputStream;

import org.eclipse.emf.common.util.URI;
import org.openarchitectureware.workflow.util.ResourceLoaderImpl;
import org.openarchitectureware.xtext.parser.IXtextParser;
import org.openarchitectureware.xtext.resource.AbstractXtextResource;

import eu.ipac.ace.adl.parser.XtextParser;

public class IpacADLResource extends AbstractXtextResource {
	public IpacADLResource(URI uri) {
		super(uri);
		setFormattingExtension("eu::ipac::ace::adl::Formatting");
		setResourceLoader(new ResourceLoaderImpl(XtextParser.class.getClassLoader()));
	}

	@Override
	protected IXtextParser createParser(InputStream inputStream) {
		return new XtextParser(inputStream);
	}

}

