lexer grammar IpacADL;
@members {
	 private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
	public List<ErrorMsg> getErrors() {
		return errors;
	}

	public String getErrorMessage(RecognitionException e, String[] tokenNames) {
		String msg = super.getErrorMessage(e,tokenNames);
		errors.add(AntlrUtil.create(msg,e,tokenNames));
		return msg;
	}
}
@header {
package eu.ipac.ace.adl.parser;

import org.openarchitectureware.xtext.parser.ErrorMsg;
import org.openarchitectureware.xtext.parser.impl.AntlrUtil;

}

T11 : 'application' ;
T12 : '{' ;
T13 : '}' ;
T14 : 'event' ;
T15 : 'property' ;
T16 : 'value' ;
T17 : '.' ;
T18 : 'entry' ;
T19 : 'body' ;
T20 : 'const' ;
T21 : 'as' ;
T22 : 'var' ;
T23 : 'vector' ;
T24 : 'int' ;
T25 : 'double' ;
T26 : 'String' ;
T27 : 'boolean' ;
T28 : 'true' ;
T29 : 'false' ;
T30 : 'if' ;
T31 : '(' ;
T32 : ')' ;
T33 : 'else' ;
T34 : 'switch' ;
T35 : 'case' ;
T36 : ':' ;
T37 : 'default:' ;
T38 : 'listen' ;
T39 : 'blocked' ;
T40 : 'nonBlocked' ;
T41 : 'invoke' ;
T42 : 'method' ;
T43 : ',' ;
T44 : 'onFault' ;
T45 : 'set' ;
T46 : '=' ;
T47 : 'while' ;
T48 : 'break' ;
T49 : 'wait' ;
T50 : 'or' ;
T51 : 'and' ;
T52 : '==' ;
T53 : '!=' ;
T54 : '<=' ;
T55 : '>=' ;
T56 : '<' ;
T57 : '>' ;
T58 : '+' ;
T59 : '-' ;
T60 : '*' ;
T61 : '/' ;
T62 : '%' ;

// $ANTLR src "..//eu.ipac.ace.adl/src-gen/eu/ipac/ace/adl/parser/IpacADL.g" 743
RULE_DOUBLE :

	 ('0'..'9')*'.'('0'..'9')+
;

// $ANTLR src "..//eu.ipac.ace.adl/src-gen/eu/ipac/ace/adl/parser/IpacADL.g" 1817
RULE_ID :

	 ('^')?('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
	 
;

// $ANTLR src "..//eu.ipac.ace.adl/src-gen/eu/ipac/ace/adl/parser/IpacADL.g" 1823
RULE_STRING :

	 '\"' ( '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') | ~('\\'|'\"') )* '\"' |
	 '\'' ( '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') | ~('\\'|'\'') )* '\''
	 
;

// $ANTLR src "..//eu.ipac.ace.adl/src-gen/eu/ipac/ace/adl/parser/IpacADL.g" 1830
RULE_INT :

	 ('-')?('0'..'9')+
	 
;

// $ANTLR src "..//eu.ipac.ace.adl/src-gen/eu/ipac/ace/adl/parser/IpacADL.g" 1836
RULE_WS :

	 (' '|'\t'|'\r'|'\n')+ {$channel=HIDDEN;}
	 
;

// $ANTLR src "..//eu.ipac.ace.adl/src-gen/eu/ipac/ace/adl/parser/IpacADL.g" 1842
RULE_ML_COMMENT :

	 '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
	 
;

// $ANTLR src "..//eu.ipac.ace.adl/src-gen/eu/ipac/ace/adl/parser/IpacADL.g" 1848
RULE_SL_COMMENT :

	 '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
	 
;

