grammar IpacADL;
 options{backtrack=true; memoize=true;} 

@lexer::header {
package eu.ipac.ace.adl.parser;

import org.openarchitectureware.xtext.parser.ErrorMsg;
import org.openarchitectureware.xtext.parser.impl.AntlrUtil;

}

@parser::header {
package eu.ipac.ace.adl.parser;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;

import org.openarchitectureware.xtext.parser.impl.AntlrUtil;
import org.openarchitectureware.xtext.XtextFile;
import org.openarchitectureware.xtext.parser.impl.EcoreModelFactory;
import org.openarchitectureware.xtext.parser.ErrorMsg;
import org.openarchitectureware.xtext.parser.model.ParseTreeManagerNeu;
import org.openarchitectureware.xtext.parser.parsetree.Node;

import eu.ipac.ace.adl.MetaModelRegistration;

}
@lexer::members {
	 private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
	public List<ErrorMsg> getErrors() {
		return errors;
	}

	public String getErrorMessage(RecognitionException e, String[] tokenNames) {
		String msg = super.getErrorMessage(e,tokenNames);
		errors.add(AntlrUtil.create(msg,e,tokenNames));
		return msg;
	}
}

@parser::members {

	private Token getLastToken() {
		return input.LT(-1);
	}

	protected Object convert(Object arg) {
		if (arg instanceof org.antlr.runtime.Token) {
			Token t = (Token) arg;
			String s = t.getText();
			if (t.getType() == IpacADLLexer.RULE_ID && s.startsWith("^")) {
				return s.substring(1);
			} else if (t.getType()==IpacADLLexer.RULE_STRING) {
				return s.substring(1,s.length()-1);
			} else if (t.getType()==IpacADLLexer.RULE_INT) {
				return Integer.valueOf(s);
			}
			return s;
		}
		return arg;
	}


	private EcoreModelFactory factory = new EcoreModelFactory(MetaModelRegistration.getEPackage());
    private ParseTreeManagerNeu ptm = new ParseTreeManagerNeu();
	private XtextFile xtextfile = MetaModelRegistration.getXtextFile();
	
	{
		
	}

	public ParseTreeManagerNeu getResult() {
		return ptm;
	}

	private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
	public List<ErrorMsg> getErrors() {
		return errors;
	}

	@Override
	public void reportError(RecognitionException e) {
		String msg = super.getErrorMessage(e,tokenNames);
		errors.add(AntlrUtil.create(msg,e,tokenNames));
		ptm.addError(msg, e);
		// This doesn't work. ANTLR may simply report an superfluous token. In that case,
		// two nodes will be finished instead of one.
		// ptm.ruleFinished(null, end());
	}

    private boolean skipCurrentToken;
    
	@Override
	protected boolean recoverFromMismatchedElement(IntStream arg0, RecognitionException arg1, BitSet arg2) {
		skipCurrentToken = true;
		return super.recoverFromMismatchedElement(arg0, arg1, arg2);
	}
}


parse returns [Node r]:
	 result=ruleApplication
	 // Always return the root node! This prevents that this method is called multiple times
	 // with interesting side effects.
{
if (result != null)
  ptm.setModelElement(result);
$r = ptm.getCurrent();
ptm.ruleFinished(result);}	 EOF
;

ruleApplication returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "Application");
			 }
(({skipCurrentToken = false;}
'application'{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(0)));
  factory.set($result,"kApplication",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"appName",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(3)));}temp_Declaration=
ruleDeclaration{if (temp_Declaration != null) {
  hasContent = true;
  ptm.setModelElement(temp_Declaration);
  factory.add($result,"declarations",convert(temp_Declaration),false);
  ptm.ruleFinished(temp_Declaration);
} else {
  ptm.destroyNode();
}
}
)*

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(4)));}temp_EventHandler=
ruleEventHandler{if (temp_EventHandler != null) {
  hasContent = true;
  ptm.setModelElement(temp_EventHandler);
  factory.add($result,"eventHandlers",convert(temp_EventHandler),false);
  ptm.ruleFinished(temp_EventHandler);
} else {
  ptm.destroyNode();
}
}
)*

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(5)));}temp_EntryPoint=
ruleEntryPoint{if (temp_EntryPoint != null) {
  hasContent = true;
  ptm.setModelElement(temp_EntryPoint);
  factory.add($result,"entryPoints",convert(temp_EntryPoint),false);
  ptm.ruleFinished(temp_EntryPoint);
} else {
  ptm.destroyNode();
}
}
)*

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(6)));}temp_Body=
ruleBody{if (temp_Body != null) {
  hasContent = true;
  ptm.setModelElement(temp_Body);
  factory.set($result,"body",convert(temp_Body),false);
  ptm.ruleFinished(temp_Body);
} else {
  ptm.destroyNode();
}
}
)

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(0)).eContents().get(1)).eContents().get(7)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleEventHandler returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "EventHandler");
			 }
(({skipCurrentToken = false;}'event'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(1)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(1)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"name",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(1)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(1)).eContents().get(1)).eContents().get(3)));}temp_EventAssignmentStatement=
ruleEventAssignmentStatement{if (temp_EventAssignmentStatement != null) {
  hasContent = true;
  ptm.setModelElement(temp_EventAssignmentStatement);
  factory.add($result,"eventAssignments",convert(temp_EventAssignmentStatement),false);
  ptm.ruleFinished(temp_EventAssignmentStatement);
} else {
  ptm.destroyNode();
}
}
)*

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(1)).eContents().get(1)).eContents().get(4)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"eventStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(1)).eContents().get(1)).eContents().get(5)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleEventAssignmentStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "EventAssignmentStatement");
			 }
(({skipCurrentToken = false;}'property'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(2)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID
{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(2)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"assRef",convert(temp),true);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'value'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(2)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID
{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(2)).eContents().get(1)).eContents().get(3)));
  factory.set($result,"handlerRef",convert(temp),true);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'.'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(2)).eContents().get(1)).eContents().get(4)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(2)).eContents().get(1)).eContents().get(5)));
  factory.set($result,"propId",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleEntryPoint returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "EntryPoint");
			 }
(({skipCurrentToken = false;}'entry'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(3)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(3)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"name",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(3)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(3)).eContents().get(1)).eContents().get(3)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"entryStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(3)).eContents().get(1)).eContents().get(4)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleBody returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "Body");
			 }
(({skipCurrentToken = false;}'body'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(4)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(4)).eContents().get(1)).eContents().get(1)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(4)).eContents().get(1)).eContents().get(2)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"statements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(4)).eContents().get(1)).eContents().get(3)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleDeclaration returns [EObject result]
:
        temp_constantdeclaration=ruleConstantDeclaration {$result=temp_constantdeclaration;}	|        temp_variabledeclaration=ruleVariableDeclaration {$result=temp_variabledeclaration;}	|        temp_vectordeclaration=ruleVectorDeclaration {$result=temp_vectordeclaration;}	;

ruleConstantDeclaration returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "ConstantDeclaration");
			 }
(({skipCurrentToken = false;}'const'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(6)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(6)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"name",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'as'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(6)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(6)).eContents().get(1)).eContents().get(3)));}temp_TypeName=
ruleTypeName{if (temp_TypeName != null) {
  hasContent = true;
  factory.set($result,"type",convert(temp_TypeName),false);
  ptm.ruleFinished(temp_TypeName);
} else {
  ptm.destroyNode();
}
}
)

({skipCurrentToken = false;}'value'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(6)).eContents().get(1)).eContents().get(4)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(6)).eContents().get(1)).eContents().get(5)));}temp_ConstantValue=
ruleConstantValue{if (temp_ConstantValue != null) {
  hasContent = true;
  ptm.setModelElement(temp_ConstantValue);
  factory.set($result,"cValue",convert(temp_ConstantValue),false);
  ptm.ruleFinished(temp_ConstantValue);
} else {
  ptm.destroyNode();
}
}
)
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleVariableDeclaration returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "VariableDeclaration");
			 }
(({skipCurrentToken = false;}'var'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(7)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(7)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"name",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'as'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(7)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(7)).eContents().get(1)).eContents().get(3)));}temp_TypeName=
ruleTypeName{if (temp_TypeName != null) {
  hasContent = true;
  factory.set($result,"type",convert(temp_TypeName),false);
  ptm.ruleFinished(temp_TypeName);
} else {
  ptm.destroyNode();
}
}
)

(({skipCurrentToken = false;}'value'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(7)).eContents().get(1)).eContents().get(4)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(7)).eContents().get(1)).eContents().get(4)).eContents().get(1)));}temp_ConstantValue=
ruleConstantValue{if (temp_ConstantValue != null) {
  hasContent = true;
  ptm.setModelElement(temp_ConstantValue);
  factory.set($result,"cValue",convert(temp_ConstantValue),false);
  ptm.ruleFinished(temp_ConstantValue);
} else {
  ptm.destroyNode();
}
}
)
)?
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleVectorDeclaration returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "VectorDeclaration");
			 }
(({skipCurrentToken = false;}'vector'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(8)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(8)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"name",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'as'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(8)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(8)).eContents().get(1)).eContents().get(3)));}temp_TypeName=
ruleTypeName{if (temp_TypeName != null) {
  hasContent = true;
  factory.set($result,"type",convert(temp_TypeName),false);
  ptm.ruleFinished(temp_TypeName);
} else {
  ptm.destroyNode();
}
}
)
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleTypeName returns [Enumerator r] :
		 'int'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(9)).eContents().get(1)));
$r=factory.enumLit("", "TypeName","int");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 'double'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(9)).eContents().get(2)));
$r=factory.enumLit("", "TypeName","double");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 'String'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(9)).eContents().get(3)));
$r=factory.enumLit("", "TypeName","string");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 'boolean'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(9)).eContents().get(4)));
$r=factory.enumLit("", "TypeName","boolean");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
;

ruleConstantValue returns [EObject result]
:
        temp_integerliteral=ruleIntegerLiteral {$result=temp_integerliteral;}	|        temp_stringliteral=ruleStringLiteral {$result=temp_stringliteral;}	|        temp_doubleliteral=ruleDoubleLiteral {$result=temp_doubleliteral;}	|        temp_booleanliteral=ruleBooleanLiteral {$result=temp_booleanliteral;}	;

ruleIntegerLiteral returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "IntegerLiteral");
			 }
({skipCurrentToken = false;}
RULE_INT{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(11)).eContents().get(1)));
  factory.set($result,"intValue",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleStringLiteral returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "StringLiteral");
			 }
({skipCurrentToken = false;}
RULE_STRING{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(12)).eContents().get(1)));
  factory.set($result,"strValue",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleBooleanLiteral returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "BooleanLiteral");
			 }
({ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(13)).eContents().get(1)));}temp_BooleanEnum=
ruleBooleanEnum{if (temp_BooleanEnum != null) {
  hasContent = true;
  factory.set($result,"booleanValue",convert(temp_BooleanEnum),false);
  ptm.ruleFinished(temp_BooleanEnum);
} else {
  ptm.destroyNode();
}
}
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleBooleanEnum returns [Enumerator r] :
		 'true'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(14)).eContents().get(1)));
$r=factory.enumLit("", "BooleanEnum","true");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 'false'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(14)).eContents().get(2)));
$r=factory.enumLit("", "BooleanEnum","false");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
;

ruleDoubleLiteral returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "DoubleLiteral");
			 }
({skipCurrentToken = false;}
RULE_DOUBLE{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(15)).eContents().get(1)));
  factory.set($result,"doubleValue",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

RULE_DOUBLE :

	 ('0'..'9')*'.'('0'..'9')+
;

ruleStatement returns [EObject result]
:
        temp_assignmentstatement=ruleAssignmentStatement {$result=temp_assignmentstatement;}	|        temp_ifstatement=ruleIfStatement {$result=temp_ifstatement;}	|        temp_switchstatement=ruleSwitchStatement {$result=temp_switchstatement;}	|        temp_invokestatement=ruleInvokeStatement {$result=temp_invokestatement;}	|        temp_listenstatement=ruleListenStatement {$result=temp_listenstatement;}	|        temp_waitstatement=ruleWaitStatement {$result=temp_waitstatement;}	|        temp_iterationstatement=ruleIterationStatement {$result=temp_iterationstatement;}	|        temp_breakstatement=ruleBreakStatement {$result=temp_breakstatement;}	;

ruleIfStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "IfStatement");
			 }
(({skipCurrentToken = false;}'if'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'('{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(1)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(2)));}temp_Expression=
ruleExpression{if (temp_Expression != null) {
  hasContent = true;
  ptm.setModelElement(temp_Expression);
  factory.set($result,"ifExpression",convert(temp_Expression),false);
  ptm.ruleFinished(temp_Expression);
} else {
  ptm.destroyNode();
}
}
)

({skipCurrentToken = false;}')'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(3)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(4)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(5)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"ifStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(6)));
  ptm.ruleFinished(getLastToken());
}})

(({skipCurrentToken = false;}'else'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(7)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(7)).eContents().get(1)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(7)).eContents().get(2)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"elseStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(18)).eContents().get(1)).eContents().get(7)).eContents().get(3)));
  ptm.ruleFinished(getLastToken());
}})
)?
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleSwitchStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "SwitchStatement");
			 }
(({skipCurrentToken = false;}'switch'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'('{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(1)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(2)));}temp_Expression=
ruleExpression{if (temp_Expression != null) {
  hasContent = true;
  ptm.setModelElement(temp_Expression);
  factory.set($result,"switchExpression",convert(temp_Expression),false);
  ptm.ruleFinished(temp_Expression);
} else {
  ptm.destroyNode();
}
}
)

({skipCurrentToken = false;}')'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(3)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(4)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(5)));}temp_CaseStatement=
ruleCaseStatement{if (temp_CaseStatement != null) {
  hasContent = true;
  ptm.setModelElement(temp_CaseStatement);
  factory.add($result,"caseStatements",convert(temp_CaseStatement),false);
  ptm.ruleFinished(temp_CaseStatement);
} else {
  ptm.destroyNode();
}
}
)*

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(6)));}temp_DefaultStatement=
ruleDefaultStatement{if (temp_DefaultStatement != null) {
  hasContent = true;
  ptm.setModelElement(temp_DefaultStatement);
  factory.set($result,"defaultStatement",convert(temp_DefaultStatement),false);
  ptm.ruleFinished(temp_DefaultStatement);
} else {
  ptm.destroyNode();
}
}
)?

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(19)).eContents().get(1)).eContents().get(7)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleCaseStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "CaseStatement");
			 }
(({skipCurrentToken = false;}'case'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(20)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_INT{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(20)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"cValue",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}':'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(20)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(20)).eContents().get(1)).eContents().get(3)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"caseStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleDefaultStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "DefaultStatement");
			 }
(({skipCurrentToken = false;}'default:'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(21)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(21)).eContents().get(1)).eContents().get(1)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"defaultStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleListenStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "ListenStatement");
			 }
(({skipCurrentToken = false;}'listen'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(22)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID
{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(22)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"eventName",convert(temp),true);
  ptm.ruleFinished(temp);
}}
)

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(22)).eContents().get(1)).eContents().get(2)));}temp_EventType=
ruleEventType{if (temp_EventType != null) {
  hasContent = true;
  factory.set($result,"eventType",convert(temp_EventType),false);
  ptm.ruleFinished(temp_EventType);
} else {
  ptm.destroyNode();
}
}
)
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleEventType returns [Enumerator r] :
		 'blocked'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(23)).eContents().get(1)));
$r=factory.enumLit("", "EventType","blocked");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 'nonBlocked'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(23)).eContents().get(2)));
$r=factory.enumLit("", "EventType","nonBlocked");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
;

ruleInvokeStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "InvokeStatement");
			 }
(({skipCurrentToken = false;}'invoke'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"componentName",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'method'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(3)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(4)));
  factory.set($result,"methodName",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(5)));}temp_PrimitiveElementList=
rulePrimitiveElementList{if (temp_PrimitiveElementList != null) {
  hasContent = true;
  ptm.setModelElement(temp_PrimitiveElementList);
  factory.set($result,"primitiveEL",convert(temp_PrimitiveElementList),false);
  ptm.ruleFinished(temp_PrimitiveElementList);
} else {
  ptm.destroyNode();
}
}
)

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(6)));}temp_FaultStatement=
ruleFaultStatement{if (temp_FaultStatement != null) {
  hasContent = true;
  ptm.setModelElement(temp_FaultStatement);
  factory.set($result,"faultStatement",convert(temp_FaultStatement),false);
  ptm.ruleFinished(temp_FaultStatement);
} else {
  ptm.destroyNode();
}
}
)?

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(24)).eContents().get(1)).eContents().get(7)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

rulePrimitiveElementList returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "PrimitiveElementList");
			 }
(({skipCurrentToken = false;}'('{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(25)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

(({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(25)).eContents().get(1)).eContents().get(1)).eContents().get(0)));}temp_PrimitiveElement=
rulePrimitiveElement{if (temp_PrimitiveElement != null) {
  hasContent = true;
  ptm.setModelElement(temp_PrimitiveElement);
  factory.add($result,"primitiveElements",convert(temp_PrimitiveElement),false);
  ptm.ruleFinished(temp_PrimitiveElement);
} else {
  ptm.destroyNode();
}
}
)

(({skipCurrentToken = false;}','{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(25)).eContents().get(1)).eContents().get(1)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(25)).eContents().get(1)).eContents().get(1)).eContents().get(1)).eContents().get(1)));}temp_PrimitiveElement=
rulePrimitiveElement{if (temp_PrimitiveElement != null) {
  hasContent = true;
  ptm.setModelElement(temp_PrimitiveElement);
  factory.add($result,"primitiveElements",convert(temp_PrimitiveElement),false);
  ptm.ruleFinished(temp_PrimitiveElement);
} else {
  ptm.destroyNode();
}
}
)
)*
)?

({skipCurrentToken = false;}')'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(25)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleFaultStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "FaultStatement");
			 }
(({skipCurrentToken = false;}'onFault'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(26)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(26)).eContents().get(1)).eContents().get(1)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(26)).eContents().get(1)).eContents().get(2)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"fStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(26)).eContents().get(1)).eContents().get(3)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleAssignmentStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "AssignmentStatement");
			 }
(({skipCurrentToken = false;}'set'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(27)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_ID
{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(27)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"assRef",convert(temp),true);
  ptm.ruleFinished(temp);
}}
)

({skipCurrentToken = false;}'='{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(27)).eContents().get(1)).eContents().get(2)));
  ptm.ruleFinished(getLastToken());
}})

(({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(27)).eContents().get(1)).eContents().get(3)).eContents().get(0)));}temp_InvokeStatement=
ruleInvokeStatement{if (temp_InvokeStatement != null) {
  hasContent = true;
  ptm.setModelElement(temp_InvokeStatement);
  factory.set($result,"invokeStatement",convert(temp_InvokeStatement),false);
  ptm.ruleFinished(temp_InvokeStatement);
} else {
  ptm.destroyNode();
}
}
)
	|
({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(27)).eContents().get(1)).eContents().get(3)).eContents().get(1)));}temp_Expression=
ruleExpression{if (temp_Expression != null) {
  hasContent = true;
  ptm.setModelElement(temp_Expression);
  factory.set($result,"expression",convert(temp_Expression),false);
  ptm.ruleFinished(temp_Expression);
} else {
  ptm.destroyNode();
}
}
)
)
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleIterationStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "IterationStatement");
			 }
(({skipCurrentToken = false;}'while'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(28)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'('{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(28)).eContents().get(1)).eContents().get(1)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(28)).eContents().get(1)).eContents().get(2)));}temp_Expression=
ruleExpression{if (temp_Expression != null) {
  hasContent = true;
  ptm.setModelElement(temp_Expression);
  factory.set($result,"whileExpression",convert(temp_Expression),false);
  ptm.ruleFinished(temp_Expression);
} else {
  ptm.destroyNode();
}
}
)

({skipCurrentToken = false;}')'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(28)).eContents().get(1)).eContents().get(3)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}'{'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(28)).eContents().get(1)).eContents().get(4)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(28)).eContents().get(1)).eContents().get(5)));}temp_Statement=
ruleStatement{if (temp_Statement != null) {
  hasContent = true;
  ptm.setModelElement(temp_Statement);
  factory.add($result,"whileStatements",convert(temp_Statement),false);
  ptm.ruleFinished(temp_Statement);
} else {
  ptm.destroyNode();
}
}
)*

({skipCurrentToken = false;}'}'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(28)).eContents().get(1)).eContents().get(6)));
  ptm.ruleFinished(getLastToken());
}})
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleBreakStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "BreakStatement");
			 }
({skipCurrentToken = false;}'break'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(29)).eContents().get(1)));
  ptm.ruleFinished(getLastToken());
}})
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleWaitStatement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "WaitStatement");
			 }
(({skipCurrentToken = false;}'wait'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(30)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({skipCurrentToken = false;}
RULE_INT{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(30)).eContents().get(1)).eContents().get(1)));
  factory.set($result,"secs",convert(temp),false);
  ptm.ruleFinished(temp);
}}
)
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

rulePrimitiveElement returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "PrimitiveElement");
			 }
(({skipCurrentToken = false;}
RULE_ID
{if (!skipCurrentToken) {
  hasContent = true;
  Token temp = getLastToken();
  ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(31)).eContents().get(1)).eContents().get(0)));
  factory.set($result,"peRef",convert(temp),true);
  ptm.ruleFinished(temp);
}}
)
	|
({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(31)).eContents().get(1)).eContents().get(1)));}temp_ConstantValue=
ruleConstantValue{if (temp_ConstantValue != null) {
  hasContent = true;
  ptm.setModelElement(temp_ConstantValue);
  factory.set($result,"cValue",convert(temp_ConstantValue),false);
  ptm.ruleFinished(temp_ConstantValue);
} else {
  ptm.destroyNode();
}
}
)
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleExpression returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "Expression");
			 }
(({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(32)).eContents().get(1)).eContents().get(0)));}temp_ConditionalAndExpression=
ruleConditionalAndExpression{if (temp_ConditionalAndExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_ConditionalAndExpression);
  factory.set($result,"condAndExpr",convert(temp_ConditionalAndExpression),false);
  ptm.ruleFinished(temp_ConditionalAndExpression);
} else {
  ptm.destroyNode();
}
}
)

(({skipCurrentToken = false;}'or'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(32)).eContents().get(1)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(32)).eContents().get(1)).eContents().get(1)).eContents().get(1)));}temp_ConditionalAndExpression=
ruleConditionalAndExpression{if (temp_ConditionalAndExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_ConditionalAndExpression);
  factory.add($result,"optCondAndExpr",convert(temp_ConditionalAndExpression),false);
  ptm.ruleFinished(temp_ConditionalAndExpression);
} else {
  ptm.destroyNode();
}
}
)
)*
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleConditionalAndExpression returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "ConditionalAndExpression");
			 }
(({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(33)).eContents().get(1)).eContents().get(0)));}temp_EqualityExpression=
ruleEqualityExpression{if (temp_EqualityExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_EqualityExpression);
  factory.set($result,"equalExpr",convert(temp_EqualityExpression),false);
  ptm.ruleFinished(temp_EqualityExpression);
} else {
  ptm.destroyNode();
}
}
)

(({skipCurrentToken = false;}'and'{if (!skipCurrentToken) {
  hasContent = true;
  ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(33)).eContents().get(1)).eContents().get(1)).eContents().get(0)));
  ptm.ruleFinished(getLastToken());
}})

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(33)).eContents().get(1)).eContents().get(1)).eContents().get(1)));}temp_EqualityExpression=
ruleEqualityExpression{if (temp_EqualityExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_EqualityExpression);
  factory.add($result,"optEqualExpr",convert(temp_EqualityExpression),false);
  ptm.ruleFinished(temp_EqualityExpression);
} else {
  ptm.destroyNode();
}
}
)
)*
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleEqualityExpression returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "EqualityExpression");
			 }
(({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(34)).eContents().get(1)).eContents().get(0)));}temp_RelationalExpression=
ruleRelationalExpression{if (temp_RelationalExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_RelationalExpression);
  factory.set($result,"relExpr",convert(temp_RelationalExpression),false);
  ptm.ruleFinished(temp_RelationalExpression);
} else {
  ptm.destroyNode();
}
}
)

(({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(34)).eContents().get(1)).eContents().get(1)).eContents().get(0)));}temp_EqualityOperator=
ruleEqualityOperator{if (temp_EqualityOperator != null) {
  hasContent = true;
  factory.add($result,"equalOps",convert(temp_EqualityOperator),false);
  ptm.ruleFinished(temp_EqualityOperator);
} else {
  ptm.destroyNode();
}
}
)

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(34)).eContents().get(1)).eContents().get(1)).eContents().get(1)));}temp_RelationalExpression=
ruleRelationalExpression{if (temp_RelationalExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_RelationalExpression);
  factory.add($result,"optRelExprs",convert(temp_RelationalExpression),false);
  ptm.ruleFinished(temp_RelationalExpression);
} else {
  ptm.destroyNode();
}
}
)
)?
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleRelationalExpression returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "RelationalExpression");
			 }
(({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(35)).eContents().get(1)).eContents().get(0)));}temp_AdditiveExpression=
ruleAdditiveExpression{if (temp_AdditiveExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_AdditiveExpression);
  factory.set($result,"addExpr",convert(temp_AdditiveExpression),false);
  ptm.ruleFinished(temp_AdditiveExpression);
} else {
  ptm.destroyNode();
}
}
)

(({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(35)).eContents().get(1)).eContents().get(1)).eContents().get(0)));}temp_RelationalOperator=
ruleRelationalOperator{if (temp_RelationalOperator != null) {
  hasContent = true;
  factory.add($result,"relOps",convert(temp_RelationalOperator),false);
  ptm.ruleFinished(temp_RelationalOperator);
} else {
  ptm.destroyNode();
}
}
)

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(35)).eContents().get(1)).eContents().get(1)).eContents().get(1)));}temp_AdditiveExpression=
ruleAdditiveExpression{if (temp_AdditiveExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_AdditiveExpression);
  factory.add($result,"optAddExprs",convert(temp_AdditiveExpression),false);
  ptm.ruleFinished(temp_AdditiveExpression);
} else {
  ptm.destroyNode();
}
}
)
)?
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleAdditiveExpression returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "AdditiveExpression");
			 }
(({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(36)).eContents().get(1)).eContents().get(0)));}temp_MultiplicativeExpression=
ruleMultiplicativeExpression{if (temp_MultiplicativeExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_MultiplicativeExpression);
  factory.set($result,"multiExpr",convert(temp_MultiplicativeExpression),false);
  ptm.ruleFinished(temp_MultiplicativeExpression);
} else {
  ptm.destroyNode();
}
}
)

(({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(36)).eContents().get(1)).eContents().get(1)).eContents().get(0)));}temp_AdditiveOperator=
ruleAdditiveOperator{if (temp_AdditiveOperator != null) {
  hasContent = true;
  factory.add($result,"addOps",convert(temp_AdditiveOperator),false);
  ptm.ruleFinished(temp_AdditiveOperator);
} else {
  ptm.destroyNode();
}
}
)

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(36)).eContents().get(1)).eContents().get(1)).eContents().get(1)));}temp_MultiplicativeExpression=
ruleMultiplicativeExpression{if (temp_MultiplicativeExpression != null) {
  hasContent = true;
  ptm.setModelElement(temp_MultiplicativeExpression);
  factory.add($result,"optMultiExprs",convert(temp_MultiplicativeExpression),false);
  ptm.ruleFinished(temp_MultiplicativeExpression);
} else {
  ptm.destroyNode();
}
}
)
)*
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleMultiplicativeExpression returns [EObject result]
@init {boolean hasContent = false;}
:
			{
				$result = factory.create("", "MultiplicativeExpression");
			 }
(({ptm.createNode(((EObject)((EObject)((EObject)xtextfile.eContents().get(37)).eContents().get(1)).eContents().get(0)));}temp_PrimitiveElement=
rulePrimitiveElement{if (temp_PrimitiveElement != null) {
  hasContent = true;
  ptm.setModelElement(temp_PrimitiveElement);
  factory.set($result,"primElem",convert(temp_PrimitiveElement),false);
  ptm.ruleFinished(temp_PrimitiveElement);
} else {
  ptm.destroyNode();
}
}
)

(({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(37)).eContents().get(1)).eContents().get(1)).eContents().get(0)));}temp_MultiplicativeOperator=
ruleMultiplicativeOperator{if (temp_MultiplicativeOperator != null) {
  hasContent = true;
  factory.add($result,"multOps",convert(temp_MultiplicativeOperator),false);
  ptm.ruleFinished(temp_MultiplicativeOperator);
} else {
  ptm.destroyNode();
}
}
)

({ptm.createNode(((EObject)((EObject)((EObject)((EObject)xtextfile.eContents().get(37)).eContents().get(1)).eContents().get(1)).eContents().get(1)));}temp_PrimitiveElement=
rulePrimitiveElement{if (temp_PrimitiveElement != null) {
  hasContent = true;
  ptm.setModelElement(temp_PrimitiveElement);
  factory.add($result,"optPrimElems",convert(temp_PrimitiveElement),false);
  ptm.ruleFinished(temp_PrimitiveElement);
} else {
  ptm.destroyNode();
}
}
)
)*
)
 {if (!hasContent)
  $result = null;};
catch [RecognitionException re] {if (!hasContent)
    $result = null;
reportError(re);
recover(input,re);}

ruleEqualityOperator returns [Enumerator r] :
		 '=='
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(38)).eContents().get(1)));
$r=factory.enumLit("", "EqualityOperator","equalOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 '!='
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(38)).eContents().get(2)));
$r=factory.enumLit("", "EqualityOperator","unEqualOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
;

ruleRelationalOperator returns [Enumerator r] :
		 '<='
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(39)).eContents().get(1)));
$r=factory.enumLit("", "RelationalOperator","leOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 '>='
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(39)).eContents().get(2)));
$r=factory.enumLit("", "RelationalOperator","geOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 '<'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(39)).eContents().get(3)));
$r=factory.enumLit("", "RelationalOperator","lOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 '>'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(39)).eContents().get(4)));
$r=factory.enumLit("", "RelationalOperator","gOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
;

ruleAdditiveOperator returns [Enumerator r] :
		 '+'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(40)).eContents().get(1)));
$r=factory.enumLit("", "AdditiveOperator","addOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 '-'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(40)).eContents().get(2)));
$r=factory.enumLit("", "AdditiveOperator","minusOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
;

ruleMultiplicativeOperator returns [Enumerator r] :
		 '*'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(41)).eContents().get(1)));
$r=factory.enumLit("", "MultiplicativeOperator","multOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 '/'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(41)).eContents().get(2)));
$r=factory.enumLit("", "MultiplicativeOperator","divOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
	 |		 '%'
		 {ptm.createNode(((EObject)((EObject)xtextfile.eContents().get(41)).eContents().get(3)));
$r=factory.enumLit("", "MultiplicativeOperator","modOp");
ptm.setModelElement($r);
ptm.ruleFinished(getLastToken());
}
;

RULE_ID :

	 ('^')?('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
	 
;

RULE_STRING :

	 '\"' ( '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') | ~('\\'|'\"') )* '\"' |
	 '\'' ( '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') | ~('\\'|'\'') )* '\''
	 
;

RULE_INT :

	 ('-')?('0'..'9')+
	 
;

RULE_WS :

	 (' '|'\t'|'\r'|'\n')+ {$channel=HIDDEN;}
	 
;

RULE_ML_COMMENT :

	 '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
	 
;

RULE_SL_COMMENT :

	 '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
	 
;

