grammar debugMeWithAntlrWorks;
 options{backtrack=true; memoize=true;} 



parse :
	 result=ruleApplication
	 // Always return the root node! This prevents that this method is called multiple times
	 // with interesting side effects.
	 EOF
;

ruleApplication 

:
(('application')

(RULE_ID)

('{')

(ruleDeclaration)*

(ruleEventHandler)*

(ruleEntryPoint)*

(ruleBody)

('}')
)
;

ruleEventHandler 

:
(('event')

(RULE_ID)

('{')

(ruleEventAssignmentStatement)*

(ruleStatement)*

('}')
)
;

ruleEventAssignmentStatement 

:
(('property')

(RULE_ID
)

('value')

(RULE_ID
)

('.')

(RULE_ID)
)
;

ruleEntryPoint 

:
(('entry')

(RULE_ID)

('{')

(ruleStatement)*

('}')
)
;

ruleBody 

:
(('body')

('{')

(ruleStatement)*

('}')
)
;

ruleDeclaration 
:
        temp_constantdeclaration=ruleConstantDeclaration 	|        temp_variabledeclaration=ruleVariableDeclaration 	|        temp_vectordeclaration=ruleVectorDeclaration 	;

ruleConstantDeclaration 

:
(('const')

(RULE_ID)

('as')

(ruleTypeName)

('value')

(ruleConstantValue)
)
;

ruleVariableDeclaration 

:
(('var')

(RULE_ID)

('as')

(ruleTypeName)

(('value')

(ruleConstantValue)
)?
)
;

ruleVectorDeclaration 

:
(('vector')

(RULE_ID)

('as')

(ruleTypeName)
)
;

ruleTypeName  :
		 'int'
		 
	 |		 'double'
		 
	 |		 'String'
		 
	 |		 'boolean'
		 
;

ruleConstantValue 
:
        temp_integerliteral=ruleIntegerLiteral 	|        temp_stringliteral=ruleStringLiteral 	|        temp_doubleliteral=ruleDoubleLiteral 	|        temp_booleanliteral=ruleBooleanLiteral 	;

ruleIntegerLiteral 

:
(RULE_INT)
;

ruleStringLiteral 

:
(RULE_STRING)
;

ruleBooleanLiteral 

:
(ruleBooleanEnum)
;

ruleBooleanEnum  :
		 'true'
		 
	 |		 'false'
		 
;

ruleDoubleLiteral 

:
(RULE_DOUBLE)
;

RULE_DOUBLE :

	 ('0'..'9')*'.'('0'..'9')+
;

ruleStatement 
:
        temp_assignmentstatement=ruleAssignmentStatement 	|        temp_ifstatement=ruleIfStatement 	|        temp_switchstatement=ruleSwitchStatement 	|        temp_invokestatement=ruleInvokeStatement 	|        temp_listenstatement=ruleListenStatement 	|        temp_waitstatement=ruleWaitStatement 	|        temp_iterationstatement=ruleIterationStatement 	|        temp_breakstatement=ruleBreakStatement 	;

ruleIfStatement 

:
(('if')

('(')

(ruleExpression)

(')')

('{')

(ruleStatement)*

('}')

(('else')

('{')

(ruleStatement)*

('}')
)?
)
;

ruleSwitchStatement 

:
(('switch')

('(')

(ruleExpression)

(')')

('{')

(ruleCaseStatement)*

(ruleDefaultStatement)?

('}')
)
;

ruleCaseStatement 

:
(('case')

(RULE_INT)

(':')

(ruleStatement)*
)
;

ruleDefaultStatement 

:
(('default:')

(ruleStatement)*
)
;

ruleListenStatement 

:
(('listen')

(RULE_ID
)

(ruleEventType)
)
;

ruleEventType  :
		 'blocked'
		 
	 |		 'nonBlocked'
		 
;

ruleInvokeStatement 

:
(('invoke')

(RULE_ID)

('{')

('method')

(RULE_ID)

(rulePrimitiveElementList)

(ruleFaultStatement)?

('}')
)
;

rulePrimitiveElementList 

:
(('(')

((rulePrimitiveElement)

((',')

(rulePrimitiveElement)
)*
)?

(')')
)
;

ruleFaultStatement 

:
(('onFault')

('{')

(ruleStatement)*

('}')
)
;

ruleAssignmentStatement 

:
(('set')

(RULE_ID
)

('=')

((ruleInvokeStatement)
	|
(ruleExpression)
)
)
;

ruleIterationStatement 

:
(('while')

('(')

(ruleExpression)

(')')

('{')

(ruleStatement)*

('}')
)
;

ruleBreakStatement 

:
('break')
;

ruleWaitStatement 

:
(('wait')

(RULE_INT)
)
;

rulePrimitiveElement 

:
((RULE_ID
)
	|
(ruleConstantValue)
)
;

ruleExpression 

:
((ruleConditionalAndExpression)

(('or')

(ruleConditionalAndExpression)
)*
)
;

ruleConditionalAndExpression 

:
((ruleEqualityExpression)

(('and')

(ruleEqualityExpression)
)*
)
;

ruleEqualityExpression 

:
((ruleRelationalExpression)

((ruleEqualityOperator)

(ruleRelationalExpression)
)?
)
;

ruleRelationalExpression 

:
((ruleAdditiveExpression)

((ruleRelationalOperator)

(ruleAdditiveExpression)
)?
)
;

ruleAdditiveExpression 

:
((ruleMultiplicativeExpression)

((ruleAdditiveOperator)

(ruleMultiplicativeExpression)
)*
)
;

ruleMultiplicativeExpression 

:
((rulePrimitiveElement)

((ruleMultiplicativeOperator)

(rulePrimitiveElement)
)*
)
;

ruleEqualityOperator  :
		 '=='
		 
	 |		 '!='
		 
;

ruleRelationalOperator  :
		 '<='
		 
	 |		 '>='
		 
	 |		 '<'
		 
	 |		 '>'
		 
;

ruleAdditiveOperator  :
		 '+'
		 
	 |		 '-'
		 
;

ruleMultiplicativeOperator  :
		 '*'
		 
	 |		 '/'
		 
	 |		 '%'
		 
;

RULE_ID :

	 ('^')?('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
	 
;

RULE_STRING :

	 '\"' ( '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') | ~('\\'|'\"') )* '\"' |
	 '\'' ( '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') | ~('\\'|'\'') )* '\''
	 
;

RULE_INT :

	 ('-')?('0'..'9')+
	 
;

RULE_WS :

	 (' '|'\t'|'\r'|'\n')+ {$channel=HIDDEN;}
	 
;

RULE_ML_COMMENT :

	 '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
	 
;

RULE_SL_COMMENT :

	 '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
	 
;

