package eu.ipac.ace.adl;

import org.eclipse.emf.ecore.EObject;
import org.openarchitectureware.xtext.parser.model.NodeUtil;


public class GenUtils {
	/**
	 * @param 
	 * Capitalize the first letter of string s.
	 * @return
	 */
	public static String firstUpperCase(String s) {
		if (s.length() > 0 && Character.isLowerCase(s.charAt(0)))
			return Character.toUpperCase(s.charAt(0)) + s.substring(1);
		else
			return s;
	}
	
	/**
	 * @param 
	 * Lowercase the first letter of string s.
	 * @return
	 */
	public static String firstLowerCase(String s) {
		if (s.length() > 0 && Character.isUpperCase(s.charAt(0)))
			return Character.toLowerCase(s.charAt(0)) + s.substring(1);
		else
			return s;
	}
	
	/**
	 * Splits the string s (i.e AppName-AppID) around matches of the given regular expression. 
	 * @param s the string to be split
	 * @param regex the regular expression
	 * @return the first token (i.e the Application Name)
	 */
	public static String splitAppName(String s) {
		String[] tokens = s.split("_");
		return tokens[0];
	}
	
	/**
	 * Splits the string s (i.e AppName_AppID) around matches of the given regular expression. 
	 * @param s the string to be split
	 * @param regex the regular expression
	 * @return the second token (i.e the Application ID)
	 */
	public static String splitAppID(String s) {
		String[] tokens = s.split("_");
		return tokens[1];
	}
	
	/**
	 * See AppNameIDUtils.getAppID
	 * @param appNameID
	 * @return the application ID
	 */
	public static int getAppID(String appNameID) {
		return AppNameIDUtils.getAppID(appNameID);
	}
	
	/**
	 * 
	 * @param 
	 * @return the number of textual's editor line
	 */
	public static int getLineNumber(EObject o) {
		o.eResource().getURI();
		return NodeUtil.getNode(o).getLine();
	}

}
