package eu.ipac.ace.adl;


public class AppNameIDUtils {

	/**
	 * Retrieves the application name from the AppName_AppID representation.
	 * @param appNameID the AppName_AppID representation
	 * @return the application name 
	 */
	public static String getAppName(String appNameID) {
		String[] tokens = appNameID.split("_");
		return tokens[0];
	}
	
	/**
	 * Retrieves the application ID from the AppName_AppID representation.
	 * @param appNameID the AppName_AppID representation
	 * @return the application ID
	 */
	public static short getAppID(String appNameID) {
		String[] tokens = appNameID.split("_");
		return AppIDUtils.parseAppID(tokens[1]);
	}
	
	// Testing
	public static void main(String[] args) {
		String[] apps = { "ChatApp_3423", "FireAlarmApplication_0982" };
		
		for(int i=0; i<apps.length; i++) {
			System.out.println(apps[i] + " --> " + getAppName(apps[i]) + " | " + getAppID(apps[i]));
		}

	}

}
