package eu.ipac.ace.adl;

public class AppIDUtils {

	/**
	 * It generates a short hashCode for the string s concatenated with the system time.
	 * It uses the hashCode() function of Java String class to generate the hash value.
	 * @param s the string to be hashed
	 * @return a short integer value (i.e [-32.768, 32.767])
	 */
	public static short hashStringToShort(String s) {
		String offset = new Long(System.currentTimeMillis()).toString();
		int code = (s+offset).hashCode();
		
		return (short) code;
	}
	
	/**
	 * Creates a new AppID which corresponds to string s. 
	 * @param s the string from which the AppID will be generated
	 * @return the string representation of the AppID. If the leading digit 
	 * is zero the AppID corresponds to a negative short value. Otherwise,
	 * it is positive and a leading zero is not necessary.
	 */
	public static String createAppID(String s) {
		int code = hashStringToShort(s);
		
		if(code > 0)
			return "" + code;
		else
			return "0" + Math.abs(code);
	}
	
	/**
	 * Parses an AppID in string format. 
	 * @param s the string representation of the AppID to be parsed
	 * @return the short integer value which corresponds to the AppID.
	 */
	public static short parseAppID(String s) {
		Short num;
		
		if (s.charAt(0) == '0')	
			num = new Short("-" + s.substring(1));
		else
			num = new Short(s);
		
		return num.shortValue();
		
	}
	
	/**
	 * Main for testing purposes.
	 * @param args
	 */
	public static void main(String[] args) {
		String[] appNames = {"FireAlertApp", "ChatApp", "HMODTrialApp", "DummyApp", 
				"SmokeApp", "CriticalApp", "app3", "demo", "IPACApp", "BA"};
		
		for (int i=0; i<10; i++) {
			String s = createAppID(appNames[i]);
			System.out.println(i + ". " + s + " --> " + parseAppID(s));
		}
		
	}

}
