package eu.ipac.ace.adl.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.openarchitectureware.xtext.LanguageUtilities;
import org.openarchitectureware.xtext.XtextLog;
import org.openarchitectureware.xtext.editor.wizards.AbstractNewProjectWizard;
import org.openarchitectureware.xtext.editor.wizards.ProjectCreator;

import eu.ipac.ace.adl.IpacADLEditorPlugin;

public class NewIpacADLProjectWizard extends AbstractNewProjectWizard {

	public NewIpacADLProjectWizard() {
		super();
		setLangName("ADL");
		setGeneratorProjectName("eu.ipac.ace.adl.generator");
		setDslProjectName("eu.ipac.ace.adl");
		setFileExtension("adl");
		setPackageName("eu/ipac/ace/adl/");
	}
	
	@Override
	protected LanguageUtilities getUtilities() {
		return IpacADLEditorPlugin.getDefault().getUtilities();
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	/*
	@Override
	public boolean performFinish() {

		try {
			new WorkspaceModifyOperation() {

				@Override
				protected void execute(final IProgressMonitor monitor) throws CoreException, InvocationTargetException,
						InterruptedException {
					try {
						final IProject pr = mainPage.getProjectHandle();
						pr.create(monitor);
						pr.open(monitor);
						final String modelFileName = "model." + getFileExtension();
						ProjectCreator.create(pr, new String[] { getDslProjectName() },
								new String[] { getGeneratorProjectName() }, monitor);
						final IContainer srcFolder = pr.getFolder("src");
						ProjectCreator.createFile(modelFileName, srcFolder, "// model goes here...\n", monitor);
						ProjectCreator.createFile(pr.getName() + ".oaw", srcFolder, "<workflow>\n\t<component file='"
								+ getPackageName() + "generator.oaw'>\n\t\t<modelFile value='" + modelFileName
								+ "' />\n\t\t<targetDir value='src-gen' />\n\t</component>\n</workflow>", monitor);
					}
					catch (final CoreException e) {
						mainPage.setErrorMessage(e.getLocalizedMessage());
					}
				}
			}.run(null);
		}
		catch (final InvocationTargetException e) {
			XtextLog.logError(e);
			return false;
		}
		catch (final InterruptedException e) {
			XtextLog.logError(e);
			return false;
		}
		return true;
	}
	*/
}

