package eu.ipac.ace.adl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.openarchitectureware.xtext.AbstractLanguageUtilities;
import org.openarchitectureware.xtext.AbstractXtextEditorPlugin;
import org.openarchitectureware.xtext.XtextFile;
import org.openarchitectureware.xtext.parser.IXtextParser;

import eu.ipac.ace.adl.parser.XtextParser;

public class IpacADLUtilities extends AbstractLanguageUtilities {

	// enforce eager registration of metamodel
	private static final EPackage EPACKAGE = eu.ipac.ace.adl.MetaModelRegistration.getEPackage();
	
	@Override
	protected IXtextParser internalParse(InputStream inputStream) {
		return new XtextParser(inputStream);
	}

	public String getFileExtension() {
		return "adl";
	}

	public EPackage getEPackage() {
		return EPACKAGE;
	}

	List<String> r = new ArrayList<String>();
	{
		r.add("body");
		r.add("const");
		r.add("set");
		r.add("var");
		r.add("switch");
		r.add(">=");
		r.add("wait");
		r.add("while");
		r.add("break");
		r.add("nonBlocked");
		r.add("onFault");
		r.add("==");
		r.add("if");
		r.add("event");
		r.add("vector");
		r.add("value");
		r.add("false");
		r.add("boolean");
		r.add("blocked");
		r.add("default:");
		r.add("listen");
		r.add("else");
		r.add("application");
		r.add("int");
		r.add("or");
		r.add("%");
		r.add("*");
		r.add("true");
		r.add("+");
		r.add("as");
		r.add("property");
		r.add("double");
		r.add("/");
		r.add("-");
		r.add("and");
		r.add("<=");
		r.add("String");
		r.add("invoke");
		r.add("!=");
		r.add("entry");
		r.add("method");
		r.add("case");
		r.add(">");
		r.add("<");
	}
	public List<String> allKeywords() {
		return r;
	}

	protected ClassLoader getClassLoader() {
		return this.getClass().getClassLoader();
	}

	public IPartitionTokenScanner getPartitionScanner() {
		return new GeneratedPartitionScanner();
	}

	@Override
	public AbstractXtextEditorPlugin getXtextEditorPlugin() {
		return IpacADLEditorPlugin.getDefault();
	}
	
	@Override
	public String getPackageForExtensions() {
		return "eu::ipac::ace::adl";
	}
	
	public XtextFile getXtextFile() {
		return MetaModelRegistration.getXtextFile();
	}
	

}
